/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import java.util.HashMap;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.TDSChunkType;
import org.jagatoo.loaders.models.tds.chunks.processors.AmbientProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.DiffuseProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.FaceArrayProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.HFramesProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.HLinkProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.HierarchyHeaderProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.HierarchyProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.InstanceNameProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.MagicProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.MaterialProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.MeshMaterialProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.MeshMatrixProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.NamedObjectProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.NodeIDProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.PivotProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.PointArrayProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.PosTrackProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.RotTrackProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.SclTrackProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.ShininessProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.ShininessStrengthProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.SmoothGroupProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.SpecularProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.TexCoordProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.TexMapProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.TransparencyProcessor;
import org.jagatoo.loaders.models.tds.chunks.processors.TwoSideProcessor;
import org.jagatoo.loaders.models.tds.internal.ModelContext;

public abstract class ChunkProcessor {
    private static HashMap<Integer, ChunkProcessor> chunkProcessors = new HashMap();

    static {
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MESH_MATRIX, new MeshMatrixProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.POINT_ARRAY, new PointArrayProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.FACE_ARRAY, new FaceArrayProcessor());
        MagicProcessor magicProc = new MagicProcessor();
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.N_TRI_OBJECT, magicProc);
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.M3DMAGIC, magicProc);
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MMAGIC, magicProc);
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.HIERARCHY_NODE, magicProc);
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_ENTRY, magicProc);
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.HIERARCHY_FRAMES, new HFramesProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.HIERARCHY_HEADER, new HierarchyHeaderProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.HIERARCHY_LINK, new HLinkProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.HIERARCHY, new HierarchyProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.INSTANCE_NAME, new InstanceNameProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.NAMED_OBJECT, new NamedObjectProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.NODE_ID, new NodeIDProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.PIVOT, new PivotProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.POS_TRACK_TAG, new PosTrackProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.ROT_TRACK_TAG, new RotTrackProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.SCL_TRACK_TAG, new SclTrackProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.SMOOTH_GROUP, new SmoothGroupProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.TEX_VERTS, new TexCoordProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_TEXMAP, new TexMapProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_AMBIENT, new AmbientProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_DIFFUSE, new DiffuseProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_SPECULAR, new SpecularProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_SHININESS, new ShininessProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_SHININESS_STRENGTH, new ShininessStrengthProcessor());
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_TRANSPARENCY, new TransparencyProcessor());
        MeshMaterialProcessor matProc = new MeshMaterialProcessor();
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MSH_MAT_GROUP, matProc);
        MaterialProcessor meshMatProc = new MaterialProcessor();
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_NAME, meshMatProc);
        ChunkProcessor.storeChunkProcessorSingleton(TDSChunkType.MAT_TWO_SIDE, new TwoSideProcessor());
    }

    protected static final void storeChunkProcessorSingleton(TDSChunkType ct, ChunkProcessor cp) {
        chunkProcessors.put(ct.getID(), cp);
    }

    public static final ChunkProcessor getChunkProcessor(int id) {
        return chunkProcessors.get(id);
    }

    public static final ChunkProcessor getChunkProcessor(TDSChunkType chunkType) {
        return chunkProcessors.get(chunkType.getID());
    }

    public abstract void process(TDSFile var1, AppearanceFactory var2, GeometryFactory var3, NodeFactory var4, AnimationFactory var5, SpecialItemsHandler var6, ModelContext var7, int var8) throws IOException;
}

