/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.processors.TransformTrackProcessor;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.jagatoo.loaders.models.tds.internal.RotTransform;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Quaternion4f;

public class RotTrackProcessor
extends TransformTrackProcessor {
    public void process(TDSFile file, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, ModelContext context, int length) throws IOException {
        file.readUnsignedShort();
        file.skipBytes(8);
        int numKeys = file.readUnsignedInt();
        context.orientation = new RotTransform();
        JAGTLog.debug("Rotation key frames: ", numKeys);
        Quaternion4f prevRot = null;
        Quaternion4f tmp = new Quaternion4f();
        int i = 0;
        while (i < numKeys) {
            Quaternion4f rot;
            int frameNumber = file.readUnsignedInt();
            file.readUnsignedShort();
            float angle = file.readFloat();
            float axisX = file.readFloat();
            float axisY = file.readFloat();
            float axisZ = file.readFloat();
            if (angle == 0.0f || axisX == 0.0f && axisY == 0.0f && axisZ == 0.0f) {
                if (numKeys == 1) {
                    context.orientation.addKeyFrame(frameNumber, (float)frameNumber / (float)context.framesCount, null);
                } else {
                    context.orientation.addKeyFrame(frameNumber, (float)frameNumber / (float)context.framesCount, Quaternion4f.IDENTITY);
                }
            } else if (prevRot == null) {
                rot = new Quaternion4f();
                rot.setFromAxisAngle(axisX, axisY, axisZ, angle);
                context.orientation.addKeyFrame(frameNumber, (float)frameNumber / (float)context.framesCount, rot);
                prevRot = rot;
            } else {
                tmp.setFromAxisAngle(axisX, axisY, axisZ, angle);
                rot = new Quaternion4f(prevRot);
                rot.mul(tmp);
                context.orientation.addKeyFrame(frameNumber, (float)frameNumber / (float)context.framesCount, rot);
                prevRot = rot;
            }
            ++i;
        }
        RotTrackProcessor.checkAndApplyTransform(context, false, nodeFactory, animFactory, siHandler, file.convertZup2Yup());
    }
}

