/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.processors.ChunkProcessor;
import org.jagatoo.loaders.models.tds.internal.Face;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.jagatoo.loaders.models.tds.internal.Surface;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class SmoothGroupProcessor
extends ChunkProcessor {
    public static final int MAX_SURFACES = 33;
    private Vector3f[] normalCache;

    private void calculateSurfaces(ModelContext context) {
        int surface = 0;
        while (surface < 33) {
            this.calculateSurfaceNormals(context.surfaces[surface]);
            ++surface;
        }
        int i = 0;
        while (i < this.normalCache.length) {
            this.normalCache[i].normalize();
            ++i;
        }
    }

    private void addNormal(int index, Vector3f normal) {
        if (this.normalCache[index] == null) {
            this.normalCache[index] = new Vector3f();
        }
        this.normalCache[index].add((TupleNf)normal);
    }

    private void calculateSurfaceNormals(Surface surface) {
        for (Face face : surface.getFaces()) {
            this.addNormal(face.getCoordAIndex(), face.getNormal());
            this.addNormal(face.getCoordBIndex(), face.getNormal());
            this.addNormal(face.getCoordCIndex(), face.getNormal());
        }
    }

    private boolean sharesVertex(Face face, int vertex) {
        return face.getCoordAIndex() == vertex || face.getCoordBIndex() == vertex || face.getCoordCIndex() == vertex;
    }

    private Vector3f calculateVertexNormal(int vertex, Face thisFace, Surface surface) {
        if (this.normalCache[vertex] != null) {
            return this.normalCache[vertex];
        }
        Vector3f normal = new Vector3f((Tuple3f)thisFace.getNormal());
        for (Face otherFace : surface.getFaces()) {
            if (otherFace == thisFace || !this.sharesVertex(otherFace, vertex)) continue;
            normal.add((TupleNf)otherFace.getNormal());
        }
        normal.normalize();
        this.normalCache[vertex] = normal;
        return normal;
    }

    public void process(TDSFile file, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, ModelContext context, int length) throws IOException {
        this.normalCache = new Vector3f[context.vertexCoords.length];
        context.surfaces = new Surface[33];
        int i = 0;
        while (i < 33) {
            context.surfaces[i] = new Surface();
            ++i;
        }
        i = 0;
        while (i < context.numberOfFaces) {
            int group = file.readInt();
            long b = 1L;
            int index = 0;
            while (index < 32) {
                if (((long)group & b) > 0L) break;
                ++index;
            }
            context.faces[i].group = group;
            context.surfaces[index].addFace(context.faces[i]);
            ++i;
        }
        i = 0;
        this.calculateSurfaces(context);
        Vector3f[] normals = new Vector3f[context.vertexCoords.length];
        int[] indices = new int[context.numberOfFaces * 3];
        int surface = 0;
        while (surface < 33) {
            for (Face f : context.surfaces[surface].getFaces()) {
                normals[f.getCoordAIndex()] = this.calculateVertexNormal(f.getCoordAIndex(), f, context.surfaces[surface]);
                normals[f.getCoordBIndex()] = this.calculateVertexNormal(f.getCoordBIndex(), f, context.surfaces[surface]);
                normals[f.getCoordCIndex()] = this.calculateVertexNormal(f.getCoordCIndex(), f, context.surfaces[surface]);
                indices[i * 3] = f.getCoordAIndex();
                indices[i * 3 + 1] = f.getCoordBIndex();
                indices[i * 3 + 2] = f.getCoordCIndex();
                ++i;
            }
            ++surface;
        }
        GeometryFactory.GeometryType geomType = GeometryFactory.GeometryType.INDEXED_TRIANGLE_ARRAY;
        geomFactory.setCoordinates(context.geometry, geomType, 0, context.vertexCoords, 0, context.vertexCoords.length);
        geomFactory.setNormals(context.geometry, geomType, 0, normals, 0, normals.length);
        geomFactory.setIndex(context.geometry, geomType, 0, indices, 0, indices.length);
        if (context.textureCoords != null) {
            System.out.println(String.valueOf(context.vertexCoords.length) + ", " + normals.length + ", " + context.textureCoords.length);
            geomFactory.setTexCoords(context.geometry, geomType, 0, 2, 0, (TexCoordf<?>[])context.textureCoords, 0, context.textureCoords.length);
        }
        geomFactory.finalizeGeometry(context.geometry, geomType, 0, context.vertexCoords.length, 0, indices.length);
        context.facesCreated = true;
    }
}

