/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.processors.ChunkProcessor;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureMode;

public class TexMapProcessor
extends ChunkProcessor {
    public void process(TDSFile file, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, ModelContext context, int length) throws IOException {
        int[] chunkID = new int[]{-1};
        float percent = file.readPercentage(true, chunkID);
        String texName = percent < 0.0f ? file.readMatName(false) : file.readMatName(true);
        AbstractTexture texture = appFactory.loadOrGetTexture(texName, file.getBaseURL(), true, true, true, true, true);
        appFactory.applyTexture(texture, 0, context.appearance);
        NamedObject texA = context.textureAttributes;
        if (texA == null) {
            texA = appFactory.createTextureAttributes("MODULATE");
            appFactory.setTextureAttribsTextureMode(texA, TextureMode.MODULATE);
            context.textureAttributes = texA;
        }
        if (texture.getFormat() == TextureFormat.RGB && context.transparency == 0.0f) {
            appFactory.applyTransparancyAttributes(null, context.appearance);
        }
    }
}

