/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.chunks.processors.ChunkProcessor;
import org.jagatoo.loaders.models.tds.internal.KeyFrameFactory;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Matrix4f;

public abstract class TransformTrackProcessor
extends ChunkProcessor {
    private static final boolean IGNORE_HIERARCHY = false;

    public static void checkAndApplyTransform(ModelContext context, boolean force, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, boolean convertZup2Yup) throws IncorrectFormatException {
        NamedObject shape;
        if (context.orientation == null || context.translation == null || context.scale == null) {
            if (force) {
                if (context.orientation == null && context.translation == null && context.scale == null) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((shape = context.objectTable.get(context.nodeName)) == null && !context.nodeName.equals("$$$DUMMY")) {
            IncorrectFormatException e = new IncorrectFormatException("Can't locate referenced object.");
            JAGTLog.print(e);
            throw e;
        }
        boolean isRootNode = context.father == -1;
        NamedObject transformGroup = nodeFactory.createTransformGroup(String.valueOf(context.nodeName) + "-TG", BoundsType.SPHERE);
        siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.NESTED_TRANSFORM, transformGroup.getName(), transformGroup);
        Matrix4f masterTransform = isRootNode && convertZup2Yup ? Matrix4f.Z_UP_TO_Y_UP : null;
        Object[] keyFrames = KeyFrameFactory.createKeyFrames(masterTransform, context.framesCount, context.translation, context.orientation, context.scale, animFactory);
        Object animController = animFactory.createMeshTransformKeyFrameController(keyFrames, transformGroup);
        if (shape != null) {
            nodeFactory.translateShapeOrGeometry(shape, -context.pivot.getX(), -context.pivot.getY(), -context.pivot.getZ());
            nodeFactory.addNodeToGroup(shape, transformGroup);
        }
        context.nodeIDMap.put(context.nodeID, transformGroup);
        if (isRootNode) {
            context.rootNodes.add(transformGroup);
        } else {
            context.nestedNodes.add(transformGroup);
            NamedObject parentTG = context.nodeIDMap.get(context.father);
            nodeFactory.addNodeToGroup(transformGroup, parentTG);
        }
        if (shape != null) {
            context.unanimatedNodes.remove(shape);
        }
        context.animControllers.add(animController);
        context.instanceName = null;
        context.translation = null;
        context.scale = null;
        context.orientation = null;
        context.animationFound = true;
    }
}

