/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.internal;

import org.jagatoo.loaders.models.tds.TDSFile;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class Face {
    private final TDSFile file;
    private final int a;
    private final int b;
    private final int c;
    private final Vector3f normal;
    public int group;

    public final int getCoordAIndex() {
        return this.a;
    }

    public final int getCoordBIndex() {
        return this.b;
    }

    public final int getCoordCIndex() {
        return this.c;
    }

    public final Point3f getCoordA() {
        return this.file.getContext().vertexCoords[this.a];
    }

    public final Point3f getCoordB() {
        return this.file.getContext().vertexCoords[this.b];
    }

    public final Point3f getCoordC() {
        return this.file.getContext().vertexCoords[this.c];
    }

    public final Vector3f getNormal() {
        return this.normal;
    }

    private final Vector3f calculateFaceNormal(int a, int b, int c) {
        Vector3f vertCoordA = Vector3f.fromPool((Tuple3f)this.file.getContext().vertexCoords[a]);
        Vector3f vertCoordB = Vector3f.fromPool((Tuple3f)this.file.getContext().vertexCoords[b]);
        Vector3f vertCoordC = Vector3f.fromPool((Tuple3f)this.file.getContext().vertexCoords[c]);
        Vector3f normal = new Vector3f();
        vertCoordB.sub((TupleNf)vertCoordA);
        vertCoordC.sub((TupleNf)vertCoordA);
        normal.cross(vertCoordB, vertCoordC);
        normal.normalize();
        return normal;
    }

    public Face(TDSFile file, int vertexA, int vertexB, int vertexC) {
        this.file = file;
        this.a = vertexA;
        this.b = vertexB;
        this.c = vertexC;
        this.normal = this.calculateFaceNormal(this.a, this.b, this.c);
        file.getContext().sharedFaces[this.a].add(this);
        file.getContext().sharedFaces[this.b].add(this);
        file.getContext().sharedFaces[this.c].add(this);
    }
}

