/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.internal;

import java.util.ArrayList;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TupleNf;

public class RotTransform {
    final ArrayList<RotFrame> frames = new ArrayList();

    public void addKeyFrame(int frameIndex, float time, Quaternion4f rot) {
        this.frames.add(new RotFrame(frameIndex, time, rot));
    }

    public int getFrameByFrameNumber(int frameNumber) {
        int i = 0;
        while (i < this.frames.size()) {
            if (this.frames.get((int)i).frameIndex == frameNumber) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void getRotationAtTime(float time, Quaternion4f rotation) {
        if (this.frames.size() <= 1) {
            RotFrame frame = this.frames.get(0);
            if (frame.rot == null) {
                rotation.set(0.0f, 0.0f, 0.0f, 1.0f);
            } else {
                rotation.set((TupleNf)frame.rot);
            }
            return;
        }
        RotFrame prevFrame = null;
        RotFrame nextFrame = null;
        int i = 0;
        while (i < this.frames.size()) {
            prevFrame = this.frames.get(i);
            if (i < this.frames.size() - 1) {
                nextFrame = this.frames.get(i + 1);
                if (time >= prevFrame.time && time < nextFrame.time) {
                    break;
                }
            } else {
                nextFrame = this.frames.get(0);
            }
            ++i;
        }
        float deltaTime = nextFrame.time - prevFrame.time;
        if (i == this.frames.size() - 1) {
            deltaTime = 1.0f - prevFrame.time;
        }
        float delta = (time - prevFrame.time) / deltaTime;
        rotation.interpolate((TupleNf)prevFrame.rot, (TupleNf)nextFrame.rot, delta);
    }

    public String toString() {
        String s = String.valueOf(this.getClass().getSimpleName()) + " ( ";
        int i = 0;
        while (i < this.frames.size()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + this.frames.get((int)i).time + ": " + this.frames.get((int)i).rot;
            ++i;
        }
        s = String.valueOf(s) + " )";
        return s;
    }

    class RotFrame {
        public final int frameIndex;
        public final float time;
        public final Quaternion4f rot;

        public RotFrame(int frameIndex, float time, Quaternion4f rot) {
            this.frameIndex = frameIndex;
            this.time = time;
            this.rot = rot;
        }
    }
}

