/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.internal;

import java.util.ArrayList;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;

public class ScaleTransform {
    final ArrayList<ScaleFrame> frames = new ArrayList();

    public void addKeyFrame(int frameIndex, float time, Tuple3f scale) {
        this.frames.add(new ScaleFrame(frameIndex, time, scale));
    }

    public int getFrameByFrameNumber(int frameNumber) {
        int i = 0;
        while (i < this.frames.size()) {
            if (this.frames.get((int)i).frameIndex == frameNumber) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void getScaleAtTime(float time, Tuple3f scale) {
        if (this.frames.size() <= 1) {
            ScaleFrame frame = this.frames.get(0);
            if (frame.scale == null) {
                scale.set(1.0f, 1.0f, 1.0f);
            } else {
                scale.set((TupleNf)frame.scale);
            }
            return;
        }
        ScaleFrame prevFrame = null;
        ScaleFrame nextFrame = null;
        int i = 0;
        while (i < this.frames.size()) {
            prevFrame = this.frames.get(i);
            if (i < this.frames.size() - 1) {
                nextFrame = this.frames.get(i + 1);
                if (time >= prevFrame.time && time < nextFrame.time) {
                    break;
                }
            } else {
                nextFrame = this.frames.get(0);
                break;
            }
            ++i;
        }
        float deltaTime = nextFrame.time - prevFrame.time;
        if (i == this.frames.size() - 1) {
            deltaTime = 1.0f - prevFrame.time;
        }
        float delta = (time - prevFrame.time) / deltaTime;
        scale.set(nextFrame.scale.getX() * delta + prevFrame.scale.getX() * (1.0f - delta), nextFrame.scale.getY() * delta + prevFrame.scale.getY() * (1.0f - delta), nextFrame.scale.getZ() * delta + prevFrame.scale.getZ() * (1.0f - delta));
    }

    public String toString() {
        String s = String.valueOf(this.getClass().getSimpleName()) + " ( ";
        int i = 0;
        while (i < this.frames.size()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + this.frames.get((int)i).time + ": " + this.frames.get((int)i).scale;
            ++i;
        }
        s = String.valueOf(s) + " )";
        return s;
    }

    class ScaleFrame {
        public final int frameIndex;
        public final float time;
        public final Tuple3f scale;

        public ScaleFrame(int frameIndex, float time, Tuple3f scale) {
            this.frameIndex = frameIndex;
            this.time = time;
            this.scale = scale;
        }
    }
}

