/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.MipmapGenerator;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.cache.HashTextureCache;
import org.jagatoo.loaders.textures.cache.TextureCache;
import org.jagatoo.loaders.textures.formats.TextureFormatLoader;
import org.jagatoo.loaders.textures.formats.TextureFormatLoaderDDS;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoaderBMP;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoaderGIF;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoaderImageIOImageInputStream;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoaderPCX;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoaderSGI;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoaderTGA;
import org.jagatoo.loaders.textures.locators.TextureStreamLocator;
import org.jagatoo.loaders.textures.locators.TextureStreamLocatorFile;
import org.jagatoo.loaders.textures.locators.TextureStreamLocatorURL;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.TextureImageFormat;

public abstract class AbstractTextureLoader {
    private TextureCache textureCache;
    protected final ArrayList<TextureStreamLocator> textureStreamLocators = new ArrayList();
    protected boolean autoDotAddedOnce = false;
    protected final ArrayList<TextureImageFormatLoader> textureImageFormatLoaders = new ArrayList();
    protected final ArrayList<TextureFormatLoader> textureFormatLoaders = new ArrayList();
    protected TextureImageFormatLoader fallbackTextureImageFormatLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureCache setCache(TextureCache textureCache, boolean copyCachedTextures) {
        TextureCache textureCache2 = this.textureCache;
        synchronized (textureCache2) {
            if (textureCache == null) {
                throw new IllegalArgumentException("textureCache must not be null.");
            }
            TextureCache prevCache = this.textureCache;
            if (copyCachedTextures) {
                String[] keys = prevCache.getCachedKeys();
                int i = 0;
                while (i < keys.length) {
                    textureCache.add(keys[i], prevCache.get(keys[i]));
                    ++i;
                }
            }
            this.textureCache = textureCache;
            return prevCache;
        }
    }

    public final TextureCache getCache() {
        return this.textureCache;
    }

    public synchronized void addTextureStreamLocator(TextureStreamLocator tsl) {
        this.textureStreamLocators.add(tsl);
    }

    public synchronized TextureStreamLocatorURL addTextureStreamLocator(URL url) {
        TextureStreamLocatorURL tsl = new TextureStreamLocatorURL(url);
        this.addTextureStreamLocator(tsl);
        return tsl;
    }

    public synchronized TextureStreamLocatorURL addTextureStreamLocator(URL baseURL, String resName) throws MalformedURLException {
        return this.addTextureStreamLocator(new URL(baseURL, resName));
    }

    public synchronized TextureStreamLocatorFile addTextureStreamLocator(File file) {
        TextureStreamLocatorFile tsl = new TextureStreamLocatorFile(file);
        this.addTextureStreamLocator(tsl);
        return tsl;
    }

    public synchronized TextureStreamLocatorFile addTextureStreamLocator(String filename) {
        TextureStreamLocatorFile tsl = new TextureStreamLocatorFile(filename);
        this.addTextureStreamLocator(tsl);
        return tsl;
    }

    public synchronized boolean removeTextureStreamLocator(TextureStreamLocator tsl) {
        return this.textureStreamLocators.remove(tsl);
    }

    public synchronized void addTextureImageFormatLoader(TextureImageFormatLoader l) {
        this.textureImageFormatLoaders.add(0, l);
    }

    public synchronized boolean removeTextureImageFormatLoader(TextureImageFormatLoader l) {
        return this.textureImageFormatLoaders.remove(l);
    }

    public synchronized void addTextureFormatLoader(TextureFormatLoader tsl) {
        this.textureFormatLoaders.add(0, tsl);
    }

    public synchronized boolean removeTextureFormatLoader(TextureFormatLoader tsl) {
        return this.textureFormatLoaders.remove(tsl);
    }

    public void setFallbackTextureImageFormatLoader(TextureImageFormatLoader ftifl) {
        if (ftifl == null) {
            throw new IllegalArgumentException("ftifl must not be null.");
        }
        this.fallbackTextureImageFormatLoader = ftifl;
    }

    public final TextureImageFormatLoader getFallbackTextureImageFormatLoader() {
        return this.fallbackTextureImageFormatLoader;
    }

    protected AbstractTexture createTextureFromTextureImage(AbstractTextureImage ti, boolean loadMipmaps, TextureFactory texFactory) {
        AbstractTexture tex = texFactory.createTexture(ti.getFormat());
        tex.setImage(0, ti);
        if (loadMipmaps && ti.getFormat() != TextureImageFormat.DEPTH && ti.getFormat().getPixelSize() > 1) {
            MipmapGenerator.createMipMaps(ti, tex, texFactory);
        }
        return tex;
    }

    private static final void resetInputStreamIfTexIsNull(Object tex, BufferedInputStream in) {
        if (tex == null) {
            try {
                in.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private AbstractTextureImage tryToLoadFromTextureImageFormatLoaders(BufferedInputStream in, boolean flipVertically, boolean acceptAlpha, boolean allowStreching, TextureFactory texFactory) {
        AbstractTextureImage ti = null;
        int i = 0;
        while (i < this.textureImageFormatLoaders.size() && ti == null) {
            TextureImageFormatLoader tifl = this.textureImageFormatLoaders.get(i);
            try {
                ti = tifl.loadTextureImage(in, acceptAlpha, flipVertically, allowStreching, texFactory);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            AbstractTextureLoader.resetInputStreamIfTexIsNull(ti, in);
            ++i;
        }
        return ti;
    }

    private AbstractTexture tryToLoadFromTextureFormatLoaders(BufferedInputStream in, boolean flipVertically, boolean acceptAlpha, boolean loadMipmaps, boolean allowStreching, TextureFactory texFactory) {
        AbstractTexture tex = null;
        int i = 0;
        while (i < this.textureFormatLoaders.size() && tex == null) {
            TextureFormatLoader tfl = this.textureFormatLoaders.get(i);
            try {
                tex = tfl.loadTexture(in, acceptAlpha, flipVertically, loadMipmaps, allowStreching, texFactory);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            AbstractTextureLoader.resetInputStreamIfTexIsNull(tex, in);
            ++i;
        }
        return tex;
    }

    private AbstractTexture loadFromFallbackLoader(BufferedInputStream in, boolean flipVertically, boolean acceptAlpha, boolean loadMipmaps, boolean allowStreching, TextureFactory texFactory) {
        AbstractTextureImage ti = null;
        AbstractTexture tex = null;
        try {
            ti = this.fallbackTextureImageFormatLoader.loadTextureImage(in, acceptAlpha, flipVertically, allowStreching, texFactory);
            if (ti != null) {
                tex = this.createTextureFromTextureImage(ti, loadMipmaps, texFactory);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        AbstractTextureLoader.resetInputStreamIfTexIsNull(ti, in);
        return tex;
    }

    protected AbstractTextureImage loadTextureImageFromStream(BufferedInputStream in, boolean flipVertically, boolean acceptAlpha, boolean allowStreching, TextureFactory texFactory) {
        if (in == null) {
            return null;
        }
        int available = 0;
        try {
            available = in.available();
        }
        catch (IOException e) {
            if (!e.getMessage().contains("Stream closed")) {
                e.printStackTrace();
            }
            return null;
        }
        AbstractTextureImage texImg = null;
        if (available > 0) {
            AbstractTexture tex;
            in.mark(Integer.MAX_VALUE);
            if (texImg == null) {
                texImg = this.tryToLoadFromTextureImageFormatLoaders(in, flipVertically, acceptAlpha, allowStreching, texFactory);
            }
            if (texImg == null && (tex = this.tryToLoadFromTextureFormatLoaders(in, flipVertically, acceptAlpha, false, allowStreching, texFactory)) != null) {
                texImg = tex.getImage(0);
            }
            if (texImg == null) {
                try {
                    texImg = this.fallbackTextureImageFormatLoader.loadTextureImage(in, acceptAlpha, flipVertically, allowStreching, texFactory);
                    AbstractTextureLoader.resetInputStreamIfTexIsNull(texImg, in);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return texImg;
    }

    protected AbstractTexture loadTextureFromStream(BufferedInputStream in, boolean flipVertically, boolean acceptAlpha, boolean loadMipmaps, boolean allowStreching, TextureFactory texFactory) {
        if (in == null) {
            return null;
        }
        int available = 0;
        try {
            available = in.available();
        }
        catch (IOException e) {
            if (!e.getMessage().contains("Stream closed")) {
                e.printStackTrace();
            }
            return null;
        }
        AbstractTexture tex = null;
        if (available > 0) {
            AbstractTextureImage ti;
            in.mark(Integer.MAX_VALUE);
            if (tex == null && (ti = this.tryToLoadFromTextureImageFormatLoaders(in, flipVertically, acceptAlpha, allowStreching, texFactory)) != null) {
                tex = this.createTextureFromTextureImage(ti, loadMipmaps, texFactory);
            }
            if (tex == null) {
                tex = this.tryToLoadFromTextureFormatLoaders(in, flipVertically, acceptAlpha, loadMipmaps, allowStreching, texFactory);
            }
            if (tex == null) {
                tex = this.loadFromFallbackLoader(in, flipVertically, acceptAlpha, loadMipmaps, allowStreching, texFactory);
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tex;
    }

    protected String generateCacheKey(String name, boolean acceptAlpha, boolean loadMipmaps, boolean flipVertically, boolean allowStreching) {
        String cacheKey = String.valueOf(name) + "-" + (acceptAlpha ? "RGBA?" : "RGB") + "-" + (loadMipmaps ? "MULTI_LEVEL_MIPMAP" : "BASE_LEVEL") + "-" + (flipVertically ? "flipped" : "") + "-" + (allowStreching ? "streched?" : "unstreched");
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final AbstractTexture checkCache(String name, String key) {
        TextureCache textureCache = this.getCache();
        synchronized (textureCache) {
            AbstractTexture tex;
            block6: {
                block5: {
                    if (this.getCache().isEnabled()) break block5;
                    return null;
                }
                tex = this.getCache().get(key);
                if (tex != null) break block6;
                return null;
            }
            JAGTLog.debug("Texture [", name, "] taken from cache");
            return tex;
        }
    }

    protected BufferedInputStream getInputStream(String name) {
        InputStream in = null;
        if (!this.autoDotAddedOnce && this.textureStreamLocators.isEmpty()) {
            this.addTextureStreamLocator(new TextureStreamLocatorFile(new File(".")));
            this.autoDotAddedOnce = true;
        }
        int i = 0;
        while (i < this.textureStreamLocators.size() && in == null) {
            TextureStreamLocator tsl = this.textureStreamLocators.get(i);
            try {
                in = tsl.openTextureStream(name);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        if (in instanceof BufferedInputStream) {
            return (BufferedInputStream)in;
        }
        return new BufferedInputStream(in);
    }

    protected AbstractTextureImage loadTextureImage(String name, boolean flipVertically, boolean acceptAlpha, boolean allowStreching, TextureFactory texFactory) {
        ProfileTimer.startProfile(JAGTLog.LOG_CHANNEL, "TextureLoader::loadOrGetTextureImage");
        if (name == null || name.equals("")) {
            return null;
        }
        AbstractTextureImage texImg = null;
        BufferedInputStream in = this.getInputStream(name);
        texImg = this.loadTextureImageFromStream(in, flipVertically, acceptAlpha, allowStreching, texFactory);
        ProfileTimer.endProfile();
        return texImg;
    }

    protected abstract void onTextureLoaded(AbstractTexture var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractTexture loadOrGetTexture(String name, boolean flipVertically, boolean acceptAlpha, boolean loadMipmaps, boolean allowStreching, TextureFactory texFactory, boolean useCache, boolean writeToCache) {
        ProfileTimer.startProfile(JAGTLog.LOG_CHANNEL, "TextureLoader::loadOrGetTexture");
        if (name == null || name.equals("")) {
            return null;
        }
        AbstractTexture tex = null;
        String cacheKey = this.generateCacheKey(name, acceptAlpha, loadMipmaps, flipVertically, allowStreching);
        if (useCache && (tex = this.checkCache(name, cacheKey)) != null) {
            return tex;
        }
        BufferedInputStream in = this.getInputStream(name);
        tex = this.loadTextureFromStream(in, flipVertically, acceptAlpha, loadMipmaps, allowStreching, texFactory);
        if (tex != null) {
            if (useCache && writeToCache && this.getCache().isEnabled()) {
                TextureCache textureCache = this.getCache();
                synchronized (textureCache) {
                    this.getCache().add(cacheKey, tex);
                    tex.setCacheKey(cacheKey);
                }
            }
            tex.setName(name);
            this.onTextureLoaded(tex, name);
        }
        ProfileTimer.endProfile();
        return tex;
    }

    protected AbstractTexture loadTextureFromURL(URL imageURL, boolean flipVertically, boolean acceptAlpha, boolean loadMipmaps, boolean allowStreching, TextureFactory texFactory) {
        if (imageURL == null) {
            return null;
        }
        AbstractTexture tex = null;
        String name = null;
        try {
            name = imageURL.toURI().toString();
        }
        catch (URISyntaxException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
        InputStream in = null;
        try {
            in = imageURL.openStream();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (in == null) {
            return null;
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        if ((tex = this.loadTextureFromStream((BufferedInputStream)in, flipVertically, acceptAlpha, loadMipmaps, allowStreching, texFactory)) != null) {
            tex.setName(name);
            this.onTextureLoaded(tex, name);
        }
        return tex;
    }

    protected void initStandardFormatLoaders() {
        this.addTextureImageFormatLoader(new TextureImageFormatLoaderSGI());
        this.addTextureImageFormatLoader(new TextureImageFormatLoaderBMP());
        this.addTextureImageFormatLoader(new TextureImageFormatLoaderPCX());
        this.addTextureImageFormatLoader(new TextureImageFormatLoaderGIF());
        this.addTextureImageFormatLoader(new TextureImageFormatLoaderTGA());
        this.addTextureFormatLoader(new TextureFormatLoaderDDS());
    }

    protected AbstractTextureLoader(TextureCache textureCache, TextureImageFormatLoader fallbackTextureImageFormatLoader) {
        if (textureCache == null) {
            throw new NullPointerException("textureCache must not be null");
        }
        this.textureCache = textureCache;
        if (fallbackTextureImageFormatLoader == null) {
            throw new NullPointerException("fallbackTextureImageFormatLoader must not be null.");
        }
        this.fallbackTextureImageFormatLoader = fallbackTextureImageFormatLoader;
        this.initStandardFormatLoaders();
    }

    protected AbstractTextureLoader() {
        this(new HashTextureCache(), new TextureImageFormatLoaderImageIOImageInputStream());
    }
}

