/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jagatoo.image.BufferedImageFactory;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.util.image.ImageUtility;

public class TextureImageFormatLoaderBMP
implements TextureImageFormatLoader {
    private static final short readShort(BufferedInputStream in) throws IOException {
        int s1 = in.read() & 0xFF;
        int s2 = (in.read() & 0xFF) << 8;
        return (short)(s1 | s2);
    }

    private static final int readInt(BufferedInputStream in) throws IOException {
        int i1 = in.read() & 0xFF;
        int i2 = (in.read() & 0xFF) << 8;
        int i3 = (in.read() & 0xFF) << 16;
        int i4 = (in.read() & 0xFF) << 24;
        return i1 | i2 | i3 | i4;
    }

    private static final void readPixel(BufferedInputStream in, byte[] pixel, boolean readAlpha) throws IOException {
        pixel[2] = (byte)in.read();
        pixel[1] = (byte)in.read();
        pixel[0] = (byte)in.read();
        if (readAlpha) {
            pixel[3] = (byte)in.read();
        }
    }

    private static void transferScaledBytes(byte[] unscaledData, int bytesPerPixel, ByteBuffer bb, int orgWidth, int orgHeight, int width, int height) {
        SharedBufferedImage sbi = BufferedImageFactory.createSharedBufferedImage(orgWidth, orgHeight, bytesPerPixel, null, unscaledData);
        SharedBufferedImage sbi_scaled = ImageUtility.scaleImage(sbi, width, height, bytesPerPixel == 4);
        byte[] scaledData = sbi_scaled.getSharedData();
        int i = 0;
        while (i < scaledData.length) {
            bb.put(scaledData[i + 2]);
            bb.put(scaledData[i + 1]);
            bb.put(scaledData[i + 0]);
            if (bytesPerPixel == 4) {
                bb.put(scaledData[i + 3]);
            }
            i += bytesPerPixel;
        }
    }

    private static byte[][] readPalette(BufferedInputStream in, int IHbitCount, int IHcolorsUsed) throws IOException {
        byte[][] palette;
        if (IHcolorsUsed == 0) {
            if (IHbitCount == 1 || IHbitCount == 4 || IHbitCount == 8) {
                int paletteSize = 1 << IHbitCount;
                palette = new byte[paletteSize][4];
                int i = 0;
                while (i < paletteSize) {
                    palette[i] = new byte[4];
                    in.read(palette[i], 0, 4);
                    byte tmp = palette[i][0];
                    palette[i][0] = palette[i][2];
                    palette[i][2] = tmp;
                    ++i;
                }
            } else {
                palette = null;
            }
        } else {
            palette = new byte[IHcolorsUsed][4];
            int i = 0;
            while (i < IHcolorsUsed) {
                palette[i] = new byte[4];
                in.read(palette[i], 0, 4);
                byte tmp = palette[i][0];
                palette[i][0] = palette[i][2];
                palette[i][2] = tmp;
                ++i;
            }
        }
        return palette;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractTextureImage loadTextureImage(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        try {
            boolean palettized;
            short magicNumber = TextureImageFormatLoaderBMP.readShort(in);
            if (magicNumber != 19778) {
                return null;
            }
            TextureImageFormatLoaderBMP.readInt(in);
            TextureImageFormatLoaderBMP.readInt(in);
            TextureImageFormatLoaderBMP.readInt(in);
            TextureImageFormatLoaderBMP.readInt(in);
            int IHwidth = TextureImageFormatLoaderBMP.readInt(in);
            int IHheight = TextureImageFormatLoaderBMP.readInt(in);
            TextureImageFormatLoaderBMP.readShort(in);
            short IHbitCount = TextureImageFormatLoaderBMP.readShort(in);
            int IHcompression = TextureImageFormatLoaderBMP.readInt(in);
            int IHsizeImage = TextureImageFormatLoaderBMP.readInt(in);
            TextureImageFormatLoaderBMP.readInt(in);
            TextureImageFormatLoaderBMP.readInt(in);
            int IHcolorsUsed = TextureImageFormatLoaderBMP.readInt(in);
            TextureImageFormatLoaderBMP.readInt(in);
            int orgWidth = IHwidth;
            int orgHeight = Math.abs(IHheight);
            int bytesPerPixel = IHbitCount / 8;
            switch (IHbitCount) {
                case 1: {
                    palettized = true;
                    break;
                }
                case 4: {
                    palettized = true;
                    break;
                }
                case 8: {
                    palettized = true;
                    break;
                }
                case 16: {
                    return null;
                }
                case 24: {
                    palettized = false;
                    break;
                }
                case 32: {
                    palettized = false;
                    break;
                }
                default: {
                    throw new Error("Illegal color-size detected: " + IHbitCount);
                }
            }
            int imageDataLength = IHsizeImage;
            byte[][] palette = null;
            if (palettized) {
                palette = TextureImageFormatLoaderBMP.readPalette(in, IHbitCount, IHcolorsUsed);
                if (palette == null) {
                    palettized = false;
                } else {
                    bytesPerPixel = 3;
                }
            } else {
                imageDataLength = IHwidth * IHheight * bytesPerPixel;
            }
            switch (IHcompression) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return null;
                }
            }
            int width = ImageUtility.roundUpPower2(orgWidth);
            int height = ImageUtility.roundUpPower2(orgHeight);
            AbstractTextureImage image = texFactory.createTextureImage(width, height, orgWidth, orgHeight, acceptAlpha ? bytesPerPixel : 3);
            ByteBuffer bb = image.getDataBuffer();
            bb.limit(bb.capacity());
            int byteOffset0 = bb.position();
            int dstBytesPerPixel = image.getFormat().getPixelSize();
            byte[] imageData = null;
            int dstByteOffset = 0;
            if ((width != orgWidth || height != orgHeight) && allowStreching) {
                imageData = new byte[orgWidth * orgHeight * bytesPerPixel];
            }
            byte[] pixel = palettized ? new byte[3] : new byte[bytesPerPixel];
            int readStep = bytesPerPixel;
            if (IHbitCount <= 8) {
                readStep = 1;
            }
            int i = 0;
            while (true) {
                if (i >= imageDataLength) {
                    if (imageData != null) {
                        TextureImageFormatLoaderBMP.transferScaledBytes(imageData, dstBytesPerPixel, bb, orgWidth, orgHeight, width, height);
                    }
                    bb.position(0);
                    bb.limit(byteOffset0 + width * height * dstBytesPerPixel);
                    return image;
                }
                switch (IHbitCount) {
                    case 1: {
                        int v1 = in.read() & 1;
                        System.arraycopy(palette[v1], 0, pixel, 0, 4);
                        break;
                    }
                    case 4: {
                        int v4 = in.read() & 0xF;
                        System.arraycopy(palette[v4], 0, pixel, 0, 4);
                        break;
                    }
                    case 8: {
                        int v8 = in.read() & 0xFF;
                        System.arraycopy(palette[v8], 0, pixel, 0, 3);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 24: {
                        TextureImageFormatLoaderBMP.readPixel(in, pixel, false);
                        break;
                    }
                    case 32: {
                        TextureImageFormatLoaderBMP.readPixel(in, pixel, true);
                        break;
                    }
                }
                if (imageData == null) {
                    bb.put(pixel[0]);
                    bb.put(pixel[1]);
                    bb.put(pixel[2]);
                    if (bytesPerPixel == 4 && acceptAlpha) {
                        bb.put(pixel[3]);
                    }
                } else {
                    imageData[dstByteOffset + 0] = pixel[2];
                    imageData[dstByteOffset + 1] = pixel[1];
                    imageData[dstByteOffset + 2] = pixel[0];
                    if (bytesPerPixel == 4 && acceptAlpha) {
                        imageData[dstByteOffset + 3] = pixel[3];
                    }
                    dstByteOffset += bytesPerPixel;
                }
                i += readStep;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

