/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jagatoo.image.BufferedImageFactory;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.image.ImageUtility;

public class TextureImageFormatLoaderGIF
implements TextureImageFormatLoader {
    private static final int HEADER_FORMAT_INVALID = 0;
    private static final int HEADER_FORMAT_GIF87a = 1;
    private static final int HEADER_FORMAT_GIF89a = 2;
    private static final int[] LZW_CODE_MASK = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095};

    private static final int checkFormatHeader(BufferedInputStream in) throws IOException {
        int result = 0;
        if ((byte)in.read() != 71) {
            return 0;
        }
        if ((byte)in.read() != 73) {
            return 0;
        }
        if ((byte)in.read() != 70) {
            return 0;
        }
        if ((byte)in.read() != 56) {
            return 0;
        }
        switch ((byte)in.read()) {
            case 55: {
                result = 1;
                break;
            }
            case 57: {
                result = 2;
                break;
            }
            default: {
                return 0;
            }
        }
        if ((byte)in.read() != 97) {
            return 0;
        }
        return result;
    }

    private static final byte parseGlobalFlags(BufferedInputStream in) throws IOException {
        byte[] globalHeader = new byte[7];
        in.read(globalHeader, 0, globalHeader.length);
        byte flags = globalHeader[4];
        return flags;
    }

    private static byte[][] readColorPalette(BufferedInputStream in, int numColors) throws IOException {
        byte[][] colorPalette = new byte[numColors][];
        int i = 0;
        while (i < numColors) {
            colorPalette[i] = new byte[]{(byte)(in.read() & 0xFF), (byte)(in.read() & 0xFF), (byte)(in.read() & 0xFF)};
            ++i;
        }
        return colorPalette;
    }

    private static final int parseTransparentColorIndex(BufferedInputStream in) throws IOException {
        int transparentColorIndex = -1;
        int imageSeparator = 0;
        do {
            if ((imageSeparator = in.read()) != 33) continue;
            int func = in.read();
            int len = in.read();
            if (func == 249) {
                if ((in.read() & 1) == 1) {
                    in.skip(2L);
                    JAGTLog.debug("Found transparent GIF");
                    transparentColorIndex = in.read() & 0xFF;
                    len = in.read();
                } else {
                    in.skip(3L);
                    len = in.read();
                }
            }
            while (len != 0) {
                in.skip(len);
                len = in.read();
            }
        } while (imageSeparator != 44);
        return transparentColorIndex;
    }

    private int readLZWCode(BufferedInputStream in, GIFWorkData workData, int codeLen, int codeEndOfImage, byte[] bytesBuff) throws IOException {
        int temp = workData.tempByte >> 8 - workData.bitsRemaining;
        while (codeLen > workData.bitsRemaining) {
            if (workData.bytesAvailable == 0) {
                workData.bytesAvailable = in.read();
                if (workData.bytesAvailable > 0) {
                    in.read(bytesBuff, 0, workData.bytesAvailable);
                    workData.bufferIndex = 0;
                } else {
                    if (workData.bytesAvailable == 0) {
                        return codeEndOfImage;
                    }
                    JAGTLog.exception("bad image format");
                    throw new Error("Bad image format");
                }
            }
            workData.tempByte = bytesBuff[workData.bufferIndex++] & 0xFF;
            --workData.bytesAvailable;
            temp |= workData.tempByte << workData.bitsRemaining;
            workData.bitsRemaining += 8;
        }
        workData.bitsRemaining -= codeLen;
        return temp & LZW_CODE_MASK[codeLen - 1];
    }

    private static final void writePixel(byte[][] colorPalette, int colorIndex, ByteBuffer bb, int byteOffset0, byte[] imageData, int byteOffset, int width, int height, int lineSize, int dstBytesPerPixel, boolean flipVertically) {
        boolean writeAlpha;
        boolean bl = writeAlpha = dstBytesPerPixel == 4;
        if (flipVertically) {
            int lineByteOffset = byteOffset % lineSize;
            byteOffset = width * height * dstBytesPerPixel - (byteOffset - lineByteOffset) - lineSize + lineByteOffset;
        }
        byte[] color = colorPalette[colorIndex];
        if (imageData == null) {
            bb.position(byteOffset0 + byteOffset);
            bb.put(color, 0, 3);
            if (writeAlpha) {
                if (color.length == 4) {
                    bb.put((byte)0);
                } else {
                    bb.put((byte)-1);
                }
            }
        } else {
            System.arraycopy(color, 0, imageData, byteOffset, 3);
            if (writeAlpha) {
                imageData[byteOffset + 3] = color.length == 4 ? 0 : -1;
            }
        }
    }

    private void decodeLZWInterlacedGIFData(BufferedInputStream in, GIFWorkData workData, byte[][] colorPalette, ByteBuffer bb, byte[] imageData, int width, int height, int dstBytesPerPixel, boolean flipVertically) throws IOException {
        int code = 0;
        int tempcode = 0;
        int index = 0;
        int[] nArray = new int[8];
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 2;
        nArray[5] = 4;
        nArray[6] = 1;
        nArray[7] = 2;
        int[] pass = nArray;
        int passIndex = 0;
        int[] buff = new int[4097];
        int[] prefix = new int[4097];
        int[] suffix = new int[4097];
        byte[] bytesBuff = new byte[256];
        int incr = width * (pass[passIndex + 1] - 1);
        int numPixels = width * height;
        int min_code_size = in.read();
        int clearCode = 1 << min_code_size;
        int codeEndOfImage = clearCode + 1;
        int first_code_index = codeEndOfImage + 1;
        int codeLen = min_code_size + 1;
        int codeIndex = codeEndOfImage + 1;
        code = this.readLZWCode(in, workData, codeLen, codeEndOfImage, bytesBuff);
        while (code == clearCode) {
            code = this.readLZWCode(in, workData, codeLen, codeEndOfImage, bytesBuff);
        }
        int byteOffset0 = bb.position();
        int byteOffset = 0;
        int lineSize = width * dstBytesPerPixel;
        TextureImageFormatLoaderGIF.writePixel(colorPalette, code & 0xFF, bb, byteOffset0, imageData, byteOffset, width, height, lineSize, dstBytesPerPixel, flipVertically);
        byteOffset += dstBytesPerPixel;
        int first_char = code;
        int oldcode = code;
        block1: while (true) {
            int i = 0;
            tempcode = code = this.readLZWCode(in, workData, codeLen, codeEndOfImage, bytesBuff);
            if (code == clearCode) {
                codeLen = min_code_size + 1;
                codeIndex = codeEndOfImage;
                continue;
            }
            if (code == codeEndOfImage) break;
            if (code >= codeIndex) {
                tempcode = oldcode;
                buff[i++] = first_char;
            }
            while (tempcode >= first_code_index) {
                buff[i++] = suffix[tempcode];
                tempcode = prefix[tempcode];
            }
            buff[i++] = tempcode;
            int j = i - 1;
            while (j >= 0) {
                if (index % width == 0 && (index += incr) >= numPixels) {
                    if ((passIndex += 2) > pass.length) break block1;
                    index = width * pass[passIndex];
                    incr = width * (pass[passIndex + 1] - 1);
                }
                TextureImageFormatLoaderGIF.writePixel(colorPalette, buff[j] & 0xFF, bb, byteOffset0, imageData, byteOffset, width, height, lineSize, dstBytesPerPixel, flipVertically);
                byteOffset += dstBytesPerPixel;
                --j;
            }
            suffix[codeIndex] = first_char = tempcode;
            prefix[codeIndex++] = oldcode;
            oldcode = code;
            if (codeIndex <= (1 << codeLen) - 1 || codeLen >= 12) continue;
            ++codeLen;
        }
    }

    private void decodeLZWGIFData(BufferedInputStream in, GIFWorkData workData, byte[][] colorPalette, ByteBuffer bb, byte[] imageData, int width, int height, int dstBytesPerPixel, boolean flipVertically) throws IOException {
        int oldcode = 0;
        int code = 0;
        int tempcode = 0;
        int i = 0;
        int index = 0;
        int[] buff = new int[4097];
        int[] prefix = new int[4097];
        int[] suffix = new int[4097];
        byte[] bytesBuff = new byte[256];
        int numPixels = width * height;
        int min_code_size = in.read();
        int clearCode = 1 << min_code_size;
        int codeEndOfImage = clearCode + 1;
        int first_code_index = codeEndOfImage + 1;
        int codeLen = min_code_size + 1;
        int codeIndex = codeEndOfImage;
        int first_char = 0;
        int byteOffset0 = bb.position();
        int byteOffset = 0;
        int lineSize = width * dstBytesPerPixel;
        block0: while (true) {
            i = 0;
            tempcode = code = this.readLZWCode(in, workData, codeLen, codeEndOfImage, bytesBuff);
            if (code == clearCode) {
                codeLen = min_code_size + 1;
                codeIndex = codeEndOfImage;
                continue;
            }
            if (code == codeEndOfImage) break;
            if (code >= codeIndex) {
                tempcode = oldcode;
                buff[i++] = first_char;
            }
            while (tempcode >= first_code_index) {
                buff[i++] = suffix[tempcode];
                tempcode = prefix[tempcode];
            }
            buff[i++] = tempcode;
            int j = i - 1;
            while (j >= 0) {
                if (index >= numPixels) break block0;
                TextureImageFormatLoaderGIF.writePixel(colorPalette, buff[j] & 0xFF, bb, byteOffset0, imageData, byteOffset, width, height, lineSize, dstBytesPerPixel, flipVertically);
                byteOffset += dstBytesPerPixel;
                --j;
            }
            suffix[codeIndex] = first_char = tempcode;
            prefix[codeIndex++] = oldcode;
            oldcode = code;
            if (codeIndex <= (1 << codeLen) - 1 || codeLen >= 12) continue;
            ++codeLen;
        }
    }

    private static void transferScaledBytes(byte[] unscaledData, int bytesPerPixel, ByteBuffer bb, int orgWidth, int orgHeight, int width, int height) {
        SharedBufferedImage sbi = BufferedImageFactory.createSharedBufferedImage(orgWidth, orgHeight, bytesPerPixel, null, unscaledData);
        SharedBufferedImage sbi_scaled = ImageUtility.scaleImage(sbi, width, height, bytesPerPixel == 4);
        byte[] scaledData = sbi_scaled.getSharedData();
        int i = 0;
        while (i < scaledData.length) {
            bb.put(scaledData[i + 2]);
            bb.put(scaledData[i + 1]);
            bb.put(scaledData[i + 0]);
            if (bytesPerPixel == 4) {
                bb.put(scaledData[i + 3]);
            }
            i += bytesPerPixel;
        }
    }

    public AbstractTextureImage loadTextureImage(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        int transparentColorIndex;
        int headerFormat = TextureImageFormatLoaderGIF.checkFormatHeader(in);
        if (headerFormat == 0) {
            return null;
        }
        byte flags = TextureImageFormatLoaderGIF.parseGlobalFlags(in);
        boolean hasGlobalPalette = (flags & 0x80) == 128;
        byte[][] globalColorPalette = null;
        byte[][] colorPalette = null;
        int bitsPerPixel = 0;
        int colorsUsed = 0;
        if (hasGlobalPalette) {
            bitsPerPixel = (flags & 7) + 1;
            colorsUsed = 1 << bitsPerPixel;
            JAGTLog.debug("GIF has global color palette with ", colorsUsed, " colors");
            colorPalette = globalColorPalette = TextureImageFormatLoaderGIF.readColorPalette(in, colorsUsed);
        }
        boolean isTransparent = (transparentColorIndex = TextureImageFormatLoaderGIF.parseTransparentColorIndex(in)) >= 0;
        byte[] descriptor = new byte[9];
        in.read(descriptor, 0, descriptor.length);
        int orgWidth = descriptor[4] & 0xFF | (descriptor[5] & 0xFF) << 8;
        int orgHeight = descriptor[6] & 0xFF | (descriptor[7] & 0xFF) << 8;
        byte flags2 = descriptor[8];
        boolean hasLocalPalette = (flags2 & 0x80) == 128;
        byte[][] localColorPalette = null;
        if (hasLocalPalette) {
            bitsPerPixel = (flags2 & 7) + 1;
            colorsUsed = 1 << bitsPerPixel;
            JAGTLog.debug("GIF has local color palette with ", colorsUsed, " colors");
            colorPalette = localColorPalette = TextureImageFormatLoaderGIF.readColorPalette(in, colorsUsed);
        }
        if (isTransparent) {
            colorPalette[transparentColorIndex] = new byte[4];
        }
        int width = ImageUtility.roundUpPower2(orgWidth);
        int height = ImageUtility.roundUpPower2(orgHeight);
        AbstractTextureImage image = texFactory.createTextureImage(width, height, orgWidth, orgHeight, isTransparent && acceptAlpha ? 4 : 3);
        ByteBuffer bb = image.getDataBuffer();
        bb.limit(bb.capacity());
        int byteOffset0 = bb.position();
        int dstBytesPerPixel = image.getPixelSize();
        boolean isInterlaced = (flags2 & 0x40) == 64;
        byte[] imageData = null;
        if ((width != orgWidth || height != orgHeight) && allowStreching) {
            imageData = new byte[orgWidth * orgHeight * dstBytesPerPixel];
        }
        GIFWorkData workData = new GIFWorkData();
        if (isInterlaced) {
            this.decodeLZWInterlacedGIFData(in, workData, colorPalette, bb, imageData, orgWidth, orgHeight, dstBytesPerPixel, flipVertically);
        } else {
            this.decodeLZWGIFData(in, workData, colorPalette, bb, imageData, orgWidth, orgHeight, dstBytesPerPixel, flipVertically);
        }
        if (imageData != null) {
            TextureImageFormatLoaderGIF.transferScaledBytes(imageData, dstBytesPerPixel, bb, orgWidth, orgHeight, width, height);
        }
        bb.position(0);
        bb.limit(byteOffset0 + width * height * dstBytesPerPixel);
        return image;
    }

    private final class GIFWorkData {
        public int bitsRemaining = 0;
        public int bytesAvailable = 0;
        public int tempByte = 0;
        public int bufferIndex = 0;

        private GIFWorkData() {
        }
    }
}

