/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessor;
import org.jagatoo.util.image.ImageUtility;

public class TextureImageFormatLoaderImageIOBufferedImage
implements TextureImageFormatLoader {
    private static BufferedImage loadFromStream(InputStream in) throws IOException {
        BufferedImage result = ImageIO.read(in);
        return result;
    }

    private static AbstractTextureImage createTextureImage(BufferedImage img, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        boolean alpha;
        int height;
        int width;
        int orgWidth = img.getWidth();
        int orgHeight = img.getHeight();
        if (allowStreching) {
            width = ImageUtility.roundUpPower2(img.getWidth());
            height = ImageUtility.roundUpPower2(img.getHeight());
        } else {
            width = img.getWidth();
            height = img.getHeight();
        }
        boolean bl = alpha = img.getColorModel().hasAlpha() && acceptAlpha;
        if (orgWidth != width || orgHeight != height) {
            img = ImageUtility.scaleImage(img, width, height, alpha);
        }
        PixelProcessor pp = PixelProcessor.selectPixelProcessor(img, acceptAlpha);
        AbstractTextureImage ti = texFactory.createTextureImage(width, height, orgWidth, orgHeight, pp.getPixelSize());
        ByteBuffer bb = ti.getDataBuffer();
        bb.limit(bb.capacity());
        pp.readImageData(img, 0, 0, width, height, bb, bb.position(), flipVertically);
        return ti;
    }

    public AbstractTextureImage loadTextureImage(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        BufferedImage img = TextureImageFormatLoaderImageIOBufferedImage.loadFromStream(in);
        AbstractTextureImage ti = TextureImageFormatLoaderImageIOBufferedImage.createTextureImage(img, acceptAlpha, flipVertically, allowStreching, texFactory);
        return ti;
    }
}

