/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.util.image.ImageUtility;

public class TextureImageFormatLoaderImageIOImageInputStream
implements TextureImageFormatLoader {
    private static SharedBufferedImage loadFromStream(InputStream in, boolean acceptAlpha) throws IOException {
        SharedBufferedImage bi = null;
        ImageInputStream stream = ImageIO.createImageInputStream(in);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (iter.hasNext()) {
            ImageReader reader = iter.next();
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(stream, true, true);
            int iw = reader.getWidth(0);
            int ih = reader.getHeight(0);
            SharedBufferedImage dst = null;
            ImageTypeSpecifier its = reader.getImageTypes(0).next();
            int numChannels = its.getColorModel().getNumComponents();
            boolean hasAlpha = its.getColorModel().hasAlpha() && acceptAlpha;
            dst = SharedBufferedImage.create(iw, ih, numChannels, hasAlpha, null, null);
            param.setDestination(dst);
            bi = (SharedBufferedImage)reader.read(0, param);
            stream.close();
            reader.dispose();
        } else {
            stream.close();
        }
        return bi;
    }

    private static AbstractTextureImage createTextureImage(SharedBufferedImage img, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        boolean alpha;
        int height;
        int width;
        int orgWidth = img.getWidth();
        int orgHeight = img.getHeight();
        if (allowStreching) {
            width = ImageUtility.roundUpPower2(img.getWidth());
            height = ImageUtility.roundUpPower2(img.getHeight());
        } else {
            width = img.getWidth();
            height = img.getHeight();
        }
        boolean bl = alpha = img.getColorModel().hasAlpha() && acceptAlpha;
        if (orgWidth != width || orgHeight != height) {
            img = ImageUtility.scaleImage(img, width, height, alpha);
        }
        AbstractTextureImage ti = texFactory.createTextureImage(width, height, orgWidth, orgHeight, img.getPixelSize());
        ByteBuffer bb = ti.getDataBuffer();
        bb.limit(bb.capacity());
        byte[] imageData = img.getSharedData();
        switch (img.getPixelSize()) {
            case 4: {
                if (flipVertically) {
                    int lineSize = width * 4;
                    int y = height - 1;
                    while (y >= 0) {
                        int x = 0;
                        while (x < lineSize) {
                            int i = y * lineSize + x;
                            bb.put(imageData[i + 3]);
                            bb.put(imageData[i + 2]);
                            bb.put(imageData[i + 1]);
                            bb.put(imageData[i + 0]);
                            x += 4;
                        }
                        --y;
                    }
                } else {
                    int i = 0;
                    while (i < imageData.length) {
                        bb.put(imageData[i + 3]);
                        bb.put(imageData[i + 2]);
                        bb.put(imageData[i + 1]);
                        bb.put(imageData[i + 0]);
                        i += 4;
                    }
                }
                break;
            }
            case 3: {
                if (flipVertically) {
                    int lineSize = width * 3;
                    int y = height - 1;
                    while (y >= 0) {
                        int x = 0;
                        while (x < lineSize) {
                            int i = y * lineSize + x;
                            bb.put(imageData[i + 2]);
                            bb.put(imageData[i + 1]);
                            bb.put(imageData[i + 0]);
                            x += 3;
                        }
                        --y;
                    }
                } else {
                    int i = 0;
                    while (i < imageData.length) {
                        bb.put(imageData[i + 2]);
                        bb.put(imageData[i + 1]);
                        bb.put(imageData[i + 0]);
                        i += 3;
                    }
                }
                break;
            }
            case 2: {
                if (flipVertically) {
                    int lineSize = width * 2;
                    int y = height - 1;
                    while (y >= 0) {
                        int x = 0;
                        while (x < lineSize) {
                            int i = y * lineSize + x;
                            bb.put(imageData[i + 1]);
                            bb.put(imageData[i + 0]);
                            x += 2;
                        }
                        --y;
                    }
                } else {
                    int i = 0;
                    while (i < imageData.length) {
                        bb.put(imageData[i + 1]);
                        bb.put(imageData[i + 0]);
                        i += 2;
                    }
                }
                break;
            }
            case 1: {
                if (flipVertically) {
                    int lineSize = width * 1;
                    int y = height - 1;
                    while (y >= 0) {
                        int x = 0;
                        while (x < lineSize) {
                            int i = y * lineSize + x;
                            bb.put(imageData[i + 0]);
                            ++x;
                        }
                        --y;
                    }
                } else {
                    int i = 0;
                    while (i < imageData.length) {
                        bb.put(imageData[i + 0]);
                        ++i;
                    }
                }
                break;
            }
        }
        bb.flip();
        return ti;
    }

    public AbstractTextureImage loadTextureImage(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        SharedBufferedImage img = TextureImageFormatLoaderImageIOImageInputStream.loadFromStream(in, acceptAlpha);
        if (img == null) {
            return null;
        }
        AbstractTextureImage ti = TextureImageFormatLoaderImageIOImageInputStream.createTextureImage(img, acceptAlpha, flipVertically, allowStreching, texFactory);
        return ti;
    }
}

