/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.pixelprocessing;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessorLUM;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessorRGB;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessorRGBA;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;

public abstract class PixelProcessor {
    private final int pixelSize;

    public final int getPixelSize() {
        return this.pixelSize;
    }

    public final int getLineSize(int width) {
        return this.getPixelSize() * width;
    }

    public final int getStartOffset(int x, int y, int width) {
        return x * this.getPixelSize() + y * this.getLineSize(width);
    }

    public abstract TextureImageFormat getTextureImageFormat();

    public abstract int readImageData(BufferedImage var1, int var2, int var3, int var4, int var5, ByteBuffer var6, int var7, boolean var8);

    public AbstractTextureImage createTextureImage(BufferedImage img, int orgWidth, int orgHeight, TextureFormat format, boolean flipVertically, TextureFactory texFactory) {
        int width = img.getWidth();
        int height = img.getHeight();
        AbstractTextureImage ti = texFactory.createTextureImage(width, height, orgWidth, orgHeight, this.pixelSize, format.getDefaultTextureImageFormat());
        ByteBuffer bb = ti.getDataBuffer();
        this.readImageData(img, 0, 0, width, height, bb, 0, flipVertically);
        return ti;
    }

    public AbstractTextureImage calcMipMap(AbstractTextureImage srcImg, int trgOffset, int trgWidth, int trgHeight, int trgLineSize, TextureFactory texFactory) {
        int srcWidth = srcImg.getWidth() - 1;
        int srcHeight = srcImg.getHeight() - 1;
        int pixelSize = srcImg.getPixelSize();
        int srcLineSize = srcImg.getWidth() * srcImg.getPixelSize();
        int srcOffset = 0;
        ByteBuffer src = srcImg.getDataBuffer();
        AbstractTextureImage trgImg = texFactory.createTextureImage(trgWidth, trgHeight, trgWidth, trgHeight, pixelSize);
        ByteBuffer trg = trgImg.getDataBuffer();
        int trgOffset0 = trgOffset;
        trg.position(trgOffset0);
        trg.limit(trg.capacity());
        int y = 0;
        while (y < srcHeight) {
            int trgOffsetX = trgOffset;
            int srcOffsetX = srcOffset;
            int x = 0;
            while (x < srcWidth) {
                int i = 0;
                while (i < pixelSize) {
                    byte value = (byte)((src.get(srcOffsetX) & 0xFF) + (src.get(srcOffsetX + pixelSize) & 0xFF) + (src.get(srcOffsetX + srcLineSize) & 0xFF) + (src.get(srcOffsetX + srcLineSize + pixelSize) & 0xFF) >> 2);
                    trg.put(trgOffsetX++, value);
                    ++i;
                    ++srcOffsetX;
                }
                x += 2;
                srcOffsetX += pixelSize;
            }
            trgOffset += trgLineSize;
            srcOffset += srcLineSize << 1;
            y += 2;
        }
        int dataSize = trgHeight * trgLineSize;
        trg.position(0);
        trg.limit(trgOffset0 + dataSize);
        return trgImg;
    }

    protected PixelProcessor(int pixelSize) {
        if (pixelSize < 1 || pixelSize > 4) {
            throw new IllegalArgumentException("Unsupported pixelSize: " + pixelSize);
        }
        this.pixelSize = pixelSize;
    }

    public static final PixelProcessor selectPixelProcessor(TextureImageFormat tiFormat) {
        switch (tiFormat) {
            case INTENSITY: 
            case LUMINANCE: 
            case ALPHA: {
                return PixelProcessorLUM.getInstance();
            }
            case RGB: {
                return PixelProcessorRGB.getInstance();
            }
            case RGBA: {
                return PixelProcessorRGBA.getInstance();
            }
        }
        throw new Error("PixelProcessor for format " + (Object)((Object)tiFormat) + " not (yet) available");
    }

    public static final PixelProcessor selectPixelProcessor(TextureFormat texFormat) {
        switch (texFormat) {
            case LUMINANCE: 
            case DEPTH: {
                return PixelProcessorLUM.getInstance();
            }
            case RGB: {
                return PixelProcessorRGB.getInstance();
            }
            case RGBA: {
                return PixelProcessorRGBA.getInstance();
            }
        }
        throw new Error("PixelProcessor for format not (yet) available");
    }

    public static final PixelProcessor selectPixelProcessor(BufferedImage img, TextureFormat texFormat) {
        boolean imgHasAlpha = img.getColorModel().hasAlpha();
        boolean imgIsGrey = img.getColorModel().getNumColorComponents() == 1;
        switch (texFormat) {
            case LUMINANCE: 
            case DEPTH: {
                return PixelProcessorLUM.getInstance();
            }
            case RGB: {
                if (imgIsGrey) {
                    return PixelProcessorLUM.getInstance();
                }
                return PixelProcessorRGB.getInstance();
            }
            case RGBA: {
                if (imgHasAlpha) {
                    return PixelProcessorRGBA.getInstance();
                }
                if (imgIsGrey) {
                    return PixelProcessorLUM.getInstance();
                }
                return PixelProcessorRGB.getInstance();
            }
        }
        throw new IllegalArgumentException("Unsupported format: " + (Object)((Object)texFormat));
    }

    public static final PixelProcessor selectPixelProcessor(BufferedImage img, boolean acceptAlpha) {
        boolean imgIsGrey;
        boolean imgHasAlpha = img.getColorModel().hasAlpha();
        boolean bl = imgIsGrey = img.getColorModel().getNumColorComponents() == 1;
        if (acceptAlpha) {
            if (imgHasAlpha) {
                return PixelProcessorRGBA.getInstance();
            }
            if (imgIsGrey) {
                return PixelProcessorLUM.getInstance();
            }
            return PixelProcessorRGB.getInstance();
        }
        if (imgIsGrey) {
            return PixelProcessorLUM.getInstance();
        }
        return PixelProcessorRGB.getInstance();
    }
}

