/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.pixelprocessing;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessor;
import org.jagatoo.opengl.enums.TextureImageFormat;

public class PixelProcessorLUM
extends PixelProcessor {
    private static final PixelProcessorLUM instance = new PixelProcessorLUM();

    public static PixelProcessorLUM getInstance() {
        return instance;
    }

    public final TextureImageFormat getTextureImageFormat() {
        return TextureImageFormat.LUMINANCE;
    }

    public int readImageData(BufferedImage img, int startX, int startY, int width, int height, ByteBuffer trg, int trgOffset, boolean flipVertically) {
        ColorModel cm = img.getColorModel();
        WritableRaster r = img.getRaster();
        int trgOffset0 = trgOffset;
        trg.position(trgOffset0);
        trg.limit(trg.capacity());
        switch (img.getType()) {
            case 10: {
                Object data = new byte[width];
                int y = 0;
                while (y < height) {
                    int realY = startY + (flipVertically ? height - 1 - y : y);
                    r.getDataElements(startX, realY, width, 1, data);
                    trg.position(trgOffset);
                    trg.put((byte[])data, 0, width);
                    trgOffset += width;
                    ++y;
                }
                break;
            }
            case 1: 
            case 2: {
                Object data = new int[width];
                int y = 0;
                while (y < height) {
                    int trgOffsetX = trgOffset;
                    int realY = startY + (flipVertically ? height - 1 - y : y);
                    r.getDataElements(startX, realY, width, 1, data);
                    int x = 0;
                    while (x < width) {
                        byte rgb = data[x];
                        byte value = (byte)(((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3);
                        trg.put(trgOffsetX++, value);
                        ++x;
                    }
                    trgOffset += width;
                    ++y;
                }
                break;
            }
            default: {
                Object data = null;
                int y = 0;
                while (y < height) {
                    int trgOffsetX = trgOffset;
                    int realY = startY + (flipVertically ? height - 1 - y : y);
                    int x = 0;
                    while (x < width) {
                        data = r.getDataElements(startX + x, realY, 1, 1, data);
                        byte value = (byte)((cm.getRed(data) + cm.getGreen(data) + cm.getBlue(data)) / 3);
                        trg.put(trgOffsetX++, value);
                        ++x;
                    }
                    trgOffset += width;
                    ++y;
                }
                break block0;
            }
        }
        int dataSize = height * 1;
        trg.position(0);
        trg.limit(trgOffset0 + dataSize);
        return dataSize;
    }

    private PixelProcessorLUM() {
        super(1);
    }
}

