/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.logging;

import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.LogInterface;
import org.jagatoo.logging.LogLevel;

public class ConsoleLog
implements LogInterface {
    private int logLevel;
    private int channelFilter;

    public final void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void setChannelFilter(int filter) {
        this.channelFilter = filter;
    }

    public final int getChannelFilter() {
        return this.channelFilter;
    }

    public final boolean acceptsChannel(LogChannel channel) {
        return (this.channelFilter & channel.getID()) > 0;
    }

    public void print(LogChannel channel, int logLevel, String message) {
        if (this.acceptsChannel(channel) && logLevel <= this.logLevel) {
            if (LogLevel.isError(logLevel)) {
                System.err.print(message);
            } else {
                System.out.print(message);
            }
        }
    }

    public void println(LogChannel channel, int logLevel, String message) {
        if (this.acceptsChannel(channel) && logLevel <= this.logLevel) {
            if (LogLevel.isError(logLevel)) {
                System.err.println(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public ConsoleLog(int channelFilter, int logLevel) {
        this.logLevel = logLevel;
        this.channelFilter = channelFilter;
    }

    public ConsoleLog(int logLevel) {
        this(-1, logLevel);
    }

    public ConsoleLog() {
        this(-1, 0);
    }
}

