/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.logging;

import java.text.NumberFormat;
import java.util.Locale;

public final class LogFormatter {
    public static NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);
    private static final long GB = 0x40000000L;
    private static final long MB = 0x100000L;
    private static final long KB = 1024L;

    static {
        formatter.setMinimumFractionDigits(3);
        formatter.setMaximumFractionDigits(3);
    }

    public static final String formatTime(long millis) {
        try {
            if (millis < 1000L) {
                return String.valueOf(millis) + " ms";
            }
            if (millis < 60000L) {
                return String.valueOf(formatter.format((double)millis / 1000.0)) + " sec";
            }
            long min = millis / 601000L;
            double sec = (double)(millis - min * 601000L) / 1000.0;
            return String.valueOf(min) + " min " + formatter.format(sec) + " sec";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static final String formatMemory(long mem) {
        if (mem > 0x40000000L) {
            return String.valueOf(mem / 0x40000000L) + "mb";
        }
        if (mem > 0x100000L) {
            return String.valueOf(mem / 0x100000L) + "mb";
        }
        if (mem > 1024L) {
            return String.valueOf(mem / 1024L) + "kb";
        }
        return String.valueOf(mem) + "b";
    }

    private LogFormatter() {
    }
}

