/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.logging;

import org.jagatoo.logging.Log;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.util.timing.TimerInterface;

public class ProfileTimer {
    private static ProfileContainer containers = null;
    private static TimerInterface timer = null;
    private static boolean profilingEnabled = false;

    private ProfileTimer() {
    }

    public static void setProfilingEnabled(boolean enable, TimerInterface timerInstance) {
        profilingEnabled = enable;
        timer = timerInstance;
    }

    public static final boolean isProfilingEnabled() {
        return profilingEnabled;
    }

    private static synchronized ProfileContainer newContainer(LogChannel channel) {
        ProfileContainer c = new ProfileContainer(channel);
        c.next = containers;
        containers = c;
        return c;
    }

    public static void startProfile(LogChannel channel, String name) {
        if (!profilingEnabled) {
            return;
        }
        ProfileContainer c = containers;
        Thread t = Thread.currentThread();
        while (c != null) {
            if (t == c.thread) {
                c.startProfile(name);
                return;
            }
            c = c.next;
        }
        ProfileTimer.newContainer(channel).startProfile(name);
    }

    public static String currentProfileName() {
        if (!profilingEnabled) {
            return null;
        }
        ProfileContainer c = containers;
        Thread t = Thread.currentThread();
        while (c != null) {
            if (t == c.thread) {
                return c.currentNode.getName();
            }
            c = c.next;
        }
        return null;
    }

    public static void endProfile() {
        if (!profilingEnabled) {
            return;
        }
        ProfileContainer c = containers;
        Thread t = Thread.currentThread();
        while (c != null) {
            if (t == c.thread) {
                c.endProfile();
                return;
            }
            c = c.next;
        }
    }

    public static void printLogs() {
        if (timer == null) {
            return;
        }
        ProfileContainer c = containers;
        Log.profile(c.currentNode.channel, "Timer resolution = " + ProfileTimer.getResolution() + " ticks/second");
        Log.profile(c.currentNode.channel, "Timer resolution = " + (double)ProfileTimer.getResolution() / 1.0E9 + " ns");
        while (c != null) {
            c.printLog();
            c = c.next;
        }
    }

    public static long getTime() {
        return timer.getTime();
    }

    public static long getResolution() {
        return timer.getResolution();
    }

    public static class ProfileContainer {
        ProfileNode root;
        ProfileNode currentNode;
        Thread thread = Thread.currentThread();
        public ProfileContainer next = null;

        public ProfileContainer(LogChannel channel) {
            this.root = this.currentNode = new ProfileNode(channel, this.thread.getName(), null);
        }

        void startProfile(String name) {
            if (this.currentNode.getName() != name) {
                this.currentNode = this.currentNode.getSubNode(name);
            }
            this.currentNode.enter();
        }

        void endProfile() {
            if (this.currentNode.leave()) {
                this.currentNode = this.currentNode.getParent();
            }
        }

        void printLog() {
            while (this.currentNode != this.root && this.root.recursionCount >= 0) {
                this.endProfile();
            }
            Log.profile(this.currentNode.getChannel(), "Log for thread " + this.thread.getName());
            this.root.printLog(0);
        }
    }

    public static class ProfileNode {
        LogChannel channel;
        int numCalls;
        String name;
        long startTime;
        int recursionCount;
        long totalTime;
        ProfileNode parent;
        public ProfileNode next;
        ProfileNode children;

        ProfileNode(LogChannel channel, String name, ProfileNode parent) {
            this.channel = channel;
            this.name = name;
            this.parent = parent;
            this.recursionCount = 0;
            this.totalTime = 0L;
            this.numCalls = 0;
            this.next = null;
        }

        public LogChannel getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }

        public ProfileNode getParent() {
            return this.parent;
        }

        public void printLog(int level) {
            this.totalTime = (long)((double)this.totalTime * 1.0E9 / (double)ProfileTimer.getResolution());
            StringBuffer sb = new StringBuffer(200);
            int i = 0;
            while (i < level * 3) {
                sb.append(' ');
                ++i;
            }
            sb.append(this.name);
            sb.append(" calls=");
            sb.append(this.numCalls);
            if (this.totalTime > 0L && this.parent != null && this.parent.totalTime > 0L) {
                long percentTime = 1000L * this.totalTime / this.parent.totalTime;
                sb.append(", percent=");
                sb.append((float)percentTime / 10.0f);
                sb.append("%, ");
            }
            if (this.numCalls > 0) {
                sb.append(", avg time=");
                sb.append(this.totalTime / (long)this.numCalls);
                sb.append("ns (");
                sb.append((float)(this.totalTime / (long)this.numCalls) / 1000000.0f);
                sb.append("ms)");
            }
            Log.profile(this.channel, sb.toString());
            ProfileNode child = this.children;
            while (child != null) {
                child.printLog(level + 1);
                child = child.next;
            }
        }

        public ProfileNode getSubNode(String n) {
            ProfileNode child = this.children;
            while (child != null) {
                if (child.name == n) {
                    return child;
                }
                child = child.next;
            }
            ProfileNode newChild = new ProfileNode(this.channel, n, this);
            newChild.next = this.children;
            this.children = newChild;
            return newChild;
        }

        void enter() {
            ++this.numCalls;
            if (this.recursionCount == 0) {
                this.startTime = ProfileTimer.getTime();
            }
            ++this.recursionCount;
        }

        boolean leave() {
            if (--this.recursionCount == 0 && this.numCalls != 0) {
                long time = ProfileTimer.getTime();
                this.totalTime += time - this.startTime;
            }
            return this.recursionCount == 0;
        }
    }
}

