/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceCache<K, T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final ReferenceQueue<Entry<T>> queue = new ReferenceQueue();
    private final float loadFactor;
    private Entry<T>[] table;
    private int size;
    private int threshold;
    private int hits;
    private int misses;
    private int initialCapacity;

    public ResourceCache(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public ResourceCache(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ResourceCache() {
        this(16, 0.75f);
    }

    public void clear() {
        this.table = new Entry[this.initialCapacity];
        this.size = 0;
    }

    private static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public T get(String key) {
        this.checkQueue();
        int hash = ResourceCache.hash(key);
        Entry<Object> e = this.table[hash & this.table.length - 1];
        while (e != null) {
            if (e.hash == hash && (key == e.key || key.equals(e.key))) {
                ++this.hits;
                return e.get();
            }
            e = e.next;
        }
        ++this.misses;
        return null;
    }

    public T put(K key, T value) {
        this.checkQueue();
        if (key == null) {
            throw new IllegalArgumentException("Cache doesn't support null keys");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cache doesn't support null values");
        }
        int hash = ResourceCache.hash(key);
        int idx = hash & this.table.length - 1;
        Entry<Object> e = this.table[idx];
        Entry<T> prev = null;
        while (e != null) {
            if (e.hash == hash && (key == e.key || key.equals(e.key))) {
                e = new Entry<Entry<T>>(hash, key, value, this.queue, e.next);
                if (prev == null) {
                    this.table[idx] = e;
                } else {
                    prev.next = e;
                }
                return value;
            }
            prev = e;
            e = e.next;
        }
        this.table[idx] = new Entry<Entry<T>>(hash, key, value, this.queue, this.table[idx]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return value;
    }

    public void removeByKey(K key) {
        this.removeEntry(key);
    }

    public void removeByObject(T obj) {
    }

    private void resize(int newCapacity) {
        Entry<T>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        int i = 0;
        while (i < oldCapacity) {
            Entry<Object> e = oldTable[i];
            if (e != null) {
                Entry next;
                oldTable[i] = null;
                do {
                    next = e.next;
                    int idx = e.hash & newCapacity - 1;
                    e.next = newTable[idx];
                    newTable[idx] = e;
                } while ((e = next) != null);
            }
            ++i;
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    private void removeEntry(K key) {
        Entry<T> prev;
        int hash = ResourceCache.hash(key);
        int idx = hash & this.table.length - 1;
        Entry<Object> e = prev = this.table[idx];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && (key == e.key || key.equals(e.key))) {
                --this.size;
                if (prev == e) {
                    this.table[idx] = next;
                } else {
                    prev.next = next;
                }
                return;
            }
            prev = e;
            e = next;
        }
    }

    private void checkQueue() {
        Reference<Entry<T>> e;
        while ((e = this.queue.poll()) != null) {
            this.removeEntry(((Entry)e).key);
        }
        return;
    }

    public int getCacheHits() {
        return this.hits;
    }

    public int getCacheMisses() {
        return this.misses;
    }

    public int getCacheEntries() {
        return this.size;
    }

    public void resetStatistic() {
        this.hits = 0;
        this.misses = 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[size=" + this.size + ",hits=" + this.hits + ",misses=" + this.misses + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry<U>
    extends SoftReference<U> {
        public final K key;
        public final int hash;
        public Entry<U> next;

        public Entry(int hash, K key, U value, ReferenceQueue<U> queue, Entry next) {
            super(value, queue);
            this.hash = hash;
            this.key = key;
            this.next = next;
        }
    }
}

