/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.geometry;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.util.arrays.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon {
    private List<float[]> vertices;

    public List<float[]> getVertices() {
        return this.vertices;
    }

    public void add(float[] v) {
        this.vertices.add(v);
    }

    public void add(float x, float y, float z) {
        this.add(new float[]{x, y, z});
    }

    public boolean contains(float[] point) {
        int i = 0;
        while (i < this.vertices.size()) {
            float[] vert = this.vertices.get(i);
            if (ArrayUtils.equals(vert, point)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<Polygon> getAsTriangles() {
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        if (this.vertices.size() == 3) {
            list.add(this);
            return list;
        }
        if (this.vertices.size() > 3) {
            float[] origin = this.vertices.get(0);
            int i = 1;
            while (i < this.vertices.size() - 1) {
                Polygon tri = new Polygon();
                float[] v2 = this.vertices.get(i);
                float[] v3 = this.vertices.get(i + 1);
                tri.add(origin);
                tri.add(v2);
                tri.add(v3);
                list.add(tri);
                ++i;
            }
            return list;
        }
        return null;
    }

    public void print() {
        System.out.println("Number of vertices in polygon is " + this.vertices.size());
        int i = 0;
        while (i < this.vertices.size()) {
            System.out.println("  P" + i + ": " + this.vertices.get(i));
            ++i;
        }
    }

    public Polygon(List<float[]> vertices) {
        this.vertices = vertices;
    }

    public Polygon() {
        this(new ArrayList<float[]>());
    }
}

