/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.ini;

import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class IniWriter {
    private final BufferedWriter writer;
    private boolean spaceGroup = false;
    private String indentString = null;
    private boolean putSpacesAroundEqualSign = true;
    private int minEqualSignPosition = -1;
    private int minValuePosition = -1;
    private int minCommentPosition = -1;
    private boolean isFirstLine = true;
    private boolean isInGroup = false;

    public void setSettingIndentSpaces(int numSpaces) {
        if (numSpaces <= 0) {
            this.indentString = null;
        } else {
            char[] spaces = new char[numSpaces];
            int i = 0;
            while (i < numSpaces) {
                spaces[i] = 32;
                ++i;
            }
            this.indentString = new String(spaces);
        }
    }

    public final int getSettingIndentSpaces() {
        if (this.indentString == null) {
            return 0;
        }
        return this.indentString.length();
    }

    public void setSpaceGroup(boolean b) {
        this.spaceGroup = b;
    }

    public final boolean getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setPutSpacesAroundEqualSign(boolean b) {
        this.putSpacesAroundEqualSign = b;
    }

    public final boolean getPutSpacesAroundEqualSign() {
        return this.putSpacesAroundEqualSign;
    }

    public void setMinEqualSignPosition(int minPos) {
        this.minEqualSignPosition = minPos;
    }

    public final int getMinEqualSignPosition() {
        return this.minEqualSignPosition;
    }

    public void setMinValuePosition(int minPos) {
        this.minValuePosition = minPos;
    }

    public final int getMinValuePosition() {
        return this.minValuePosition;
    }

    public void setMinCommentPosition(int minPos) {
        this.minCommentPosition = minPos;
    }

    public final int getMinCommentPosition() {
        return this.minCommentPosition;
    }

    public void writeGroup(String group) throws IOException {
        if (!this.isFirstLine) {
            this.writer.newLine();
        }
        this.writer.write("[");
        if (this.getSpaceGroup()) {
            this.writer.write(" ");
        }
        this.writer.write(group);
        if (this.getSpaceGroup()) {
            this.writer.write(" ");
        }
        this.writer.write("]");
        this.writer.newLine();
        this.isFirstLine = false;
        this.isInGroup = true;
    }

    private static String getStyleString(Font font) {
        if (font.getStyle() == 0) {
            return "PLAIN";
        }
        String s = "";
        if ((font.getStyle() & 1) != 0) {
            s = String.valueOf(s) + "BOLD";
        }
        if ((font.getStyle() & 2) != 0) {
            s = String.valueOf(s) + "ITALIC";
        }
        return s;
    }

    public void writeSetting(String key, Object value, String comment) throws IOException {
        int i;
        int pos = 0;
        if (this.indentString != null) {
            this.writer.write(this.indentString);
            pos += this.indentString.length();
        }
        this.writer.write(key);
        if (this.getMinEqualSignPosition() > (pos += key.length())) {
            i = pos;
            while (i < this.getMinEqualSignPosition() - 1) {
                this.writer.write(32);
                ++pos;
                ++i;
            }
            if (this.getPutSpacesAroundEqualSign()) {
                this.writer.write("= ");
                pos += 2;
            } else {
                this.writer.write("=");
                ++pos;
            }
        } else if (this.getPutSpacesAroundEqualSign()) {
            this.writer.write(" = ");
            pos += 3;
        } else {
            this.writer.write("=");
            ++pos;
        }
        value = value == null ? "N/A" : (value instanceof Number || value instanceof Boolean ? String.valueOf(value) : (value instanceof Enum ? ((Enum)value).name() : (value instanceof Font ? String.valueOf(((Font)value).getName()) + "-" + IniWriter.getStyleString((Font)value) + "-" + ((Font)value).getSize() : "\"" + String.valueOf(value) + "\"")));
        if (this.getMinValuePosition() > pos) {
            i = pos;
            while (i < this.getMinValuePosition() - 1) {
                this.writer.write(32);
                ++pos;
                ++i;
            }
        }
        this.writer.write((String)value);
        pos += ((String)value).length();
        if (comment != null) {
            this.writer.write(32);
            if (this.getMinCommentPosition() > pos) {
                i = pos;
                while (i < this.getMinCommentPosition() - 1) {
                    this.writer.write(32);
                    ++pos;
                    ++i;
                }
            }
            this.writer.write("// ");
            pos += 3;
            this.writer.write(comment);
            pos += comment.length();
        }
        this.writer.newLine();
        this.isFirstLine = false;
    }

    public final void writeSetting(String key, Object value) throws IOException {
        this.writeSetting(key, value, null);
    }

    public void writeComment(String comment) throws IOException {
        if (this.isInGroup && this.indentString != null) {
            this.writer.write(this.indentString);
        }
        this.writer.write("# ");
        this.writer.write(comment);
        this.writer.newLine();
        this.isFirstLine = false;
    }

    public void writeEmptyLine() throws IOException {
        if (this.isInGroup && this.indentString != null) {
            this.writer.write(this.indentString);
        }
        this.writer.newLine();
        this.isFirstLine = false;
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public IniWriter(Writer writer) {
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public IniWriter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public IniWriter(File file) throws IOException {
        this(new FileWriter(file));
    }

    public IniWriter(String filename) throws IOException {
        this(new FileWriter(filename));
    }
}

