/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.timing;

import java.util.ArrayList;

public class Time {
    public static final double NANOSECOND = 1.0E-6;
    public static final double MICROSECOND = 0.001;
    public static final double MILLISECOND = 1.0;
    public static final double SECOND = 1000.0;
    public static final double MINUTE = 60000.0;
    public static final double HOUR = 3600000.0;
    public static final double DAY = 8.64E7;
    public static final double WEEK = 6.048E8;
    public static final double MONTH = 2.592E9;
    public static final double YEAR = 3.1536E10;
    static ArrayList<Double> units = new ArrayList();
    private double unit;
    private double value;

    static {
        units.add(1.0E-6);
        units.add(0.001);
        units.add(1.0);
        units.add(1000.0);
        units.add(60000.0);
        units.add(3600000.0);
        units.add(8.64E7);
        units.add(6.048E8);
        units.add(2.592E9);
        units.add(3.1536E10);
    }

    public Time(double value, double unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getMilliseconds() {
        return this.value * this.unit;
    }

    public double getUnit() {
        return this.unit;
    }

    public Time convertTo(double newUnit) {
        return new Time(this.value * newUnit / this.unit, newUnit);
    }
}

