/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.base;

import java.util.List;
import org.jagatoo.input.devices.components.MouseButton;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.loop.opscheduler.util.SchedOpsPool;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.ScheduledPicker;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DWrapper;
import org.xith3d.scenegraph.GroupNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PickSchedulerImpl
implements PickScheduler {
    private final Xith3DEnvironment env;

    private void pick(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, Object pl, Object userObject, boolean pickAll) {
        if (this.env.getOperationScheduler() == null) {
            throw new NullPointerException("Your Xith3DEnvironment doesn't have an attached OperationScheduler.");
        }
        ScheduledPicker sp = SchedOpsPool.allocateScheduledPicker();
        if (!pickAll) {
            sp.init(groups, canvas, button, mouseX, mouseY, (NearestPickListener)pl, userObject);
        } else {
            sp.init(groups, canvas, button, mouseX, mouseY, (AllPickListener)pl, userObject);
        }
        this.env.getOperationScheduler().scheduleOperation(sp);
    }

    private void pick(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, Object pl, Object userObject, boolean pickAll) {
        List<GroupNode> groupList = SchedOpsPool.allocateGroupList();
        groupList.add(group);
        this.pick(groupList, canvas, button, mouseX, mouseY, pl, userObject, pickAll);
        SchedOpsPool.deallocateGroupList(groupList);
    }

    @Override
    public void pickAll(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        this.pick(groups, canvas, button, mouseX, mouseY, (Object)pl, userObject, true);
    }

    @Override
    public void pickAll(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        this.pick(group, canvas, button, mouseX, mouseY, (Object)pl, userObject, true);
    }

    @Override
    public void pickAll(List<? extends GroupNode> groups, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        this.pick(groups, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, true);
    }

    @Override
    public void pickAll(GroupNode group, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        this.pick(group, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, true);
    }

    @Override
    public void pickAll(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        this.pick(groups, canvas, button, mouseX, mouseY, (Object)pl, null, true);
    }

    @Override
    public void pickAll(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        this.pick(group, canvas, button, mouseX, mouseY, (Object)pl, null, true);
    }

    @Override
    public void pickAll(List<? extends GroupNode> groups, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        this.pick(groups, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, null, true);
    }

    @Override
    public void pickAll(GroupNode group, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        this.pick(group, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, null, true);
    }

    @Override
    public void pickAll(List<? extends GroupNode> groups, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(groups, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, true);
    }

    @Override
    public void pickAll(GroupNode group, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(group, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, true);
    }

    @Override
    public void pickAll(List<? extends GroupNode> groups, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(groups, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, null, true);
    }

    @Override
    public void pickAll(GroupNode group, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(group, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, null, true);
    }

    @Override
    public void pickNearest(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        this.pick(groups, canvas, button, mouseX, mouseY, (Object)pl, userObject, false);
    }

    @Override
    public void pickNearest(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        this.pick(group, canvas, button, mouseX, mouseY, (Object)pl, userObject, false);
    }

    @Override
    public void pickNearest(List<? extends GroupNode> groups, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        this.pick(groups, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, false);
    }

    @Override
    public void pickNearest(GroupNode group, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        this.pick(group, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, false);
    }

    @Override
    public void pickNearest(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        this.pick(groups, canvas, button, mouseX, mouseY, (Object)pl, null, false);
    }

    @Override
    public void pickNearest(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        this.pick(group, canvas, button, mouseX, mouseY, (Object)pl, null, false);
    }

    @Override
    public void pickNearest(List<? extends GroupNode> groups, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        this.pick(groups, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, null, false);
    }

    @Override
    public void pickNearest(GroupNode group, Canvas3DWrapper canvasWrapper, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        this.pick(group, canvasWrapper.getCanvas(), button, mouseX, mouseY, (Object)pl, null, false);
    }

    @Override
    public void pickNearest(List<? extends GroupNode> groups, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(groups, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, false);
    }

    @Override
    public void pickNearest(GroupNode group, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(group, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, userObject, false);
    }

    @Override
    public void pickNearest(List<? extends GroupNode> groups, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(groups, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, null, false);
    }

    @Override
    public void pickNearest(GroupNode group, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        if (this.env.getCanvas() == null) {
            throw new NullPointerException("No Canvas3D added to the environment!");
        }
        this.pick(group, this.env.getCanvas(), button, mouseX, mouseY, (Object)pl, null, false);
    }

    PickSchedulerImpl(Xith3DEnvironment env) {
        this.env = env;
    }
}

