/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.base;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.EnvScreenshotEngine;
import org.xith3d.base.EnvScreenshotEngineImpl;
import org.xith3d.base.PickSchedulerImpl;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DWrapper;
import org.xith3d.render.DefaultRenderer;
import org.xith3d.render.RenderPass;
import org.xith3d.render._RNDR_PrivilegedAccess;
import org.xith3d.scenegraph.RenderableSceneGraph;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.View;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundProcessor;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.__HUD_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xith3DEnvironment
extends SceneGraph
implements RenderableSceneGraph {
    private RenderLoop renderLoop;
    private EnvScreenshotEngine screenshotEngine = null;
    private PickScheduler pickScheduler = null;
    private PhysicsEngine physicsEngine = null;
    private final ConcurrentHashMap<Canvas3D, Boolean> canvasEnabledMap;
    public boolean canvasAliveCheckSuppressed = true;
    private Canvas3D firstCanvas;
    private HashMap<Canvas3D, List<RenderPass>> canvasRenderPassMap = null;

    public void setRenderLoop(RenderLoop renderLoop) {
        this.renderLoop = renderLoop;
    }

    public final RenderLoop getRenderLoop() {
        return this.renderLoop;
    }

    public final OperationScheduler getOperationScheduler() {
        if (this.renderLoop == null) {
            return null;
        }
        return this.renderLoop.getOperationScheduler();
    }

    public void setScreenshotEngine(EnvScreenshotEngine engine) {
        this.screenshotEngine = engine;
    }

    public EnvScreenshotEngine getScreenshotEngine() {
        return this.screenshotEngine;
    }

    public void setPickScheduler(PickScheduler picker) {
        this.pickScheduler = picker;
    }

    public PickScheduler getPickScheduler() {
        return this.pickScheduler;
    }

    public void setPhysicsEngine(PhysicsEngine physEngine) {
        this.physicsEngine = physEngine;
    }

    public PhysicsEngine getPhysicsEngine() {
        return this.physicsEngine;
    }

    public final void updatePhysicsEngine(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.physicsEngine != null) {
            this.physicsEngine.update(gameTime, frameTime, timingMode);
        }
    }

    public final void updateInputSystem(long gameTime, UpdatingThread.TimingMode timingMode) {
        if (!InputSystem.hasInstance()) {
            return;
        }
        long nanoGameTime = timingMode.getNanoSeconds(gameTime);
        InputSystem inputSystem = InputSystem.getInstance();
        try {
            inputSystem.update(nanoGameTime);
        }
        catch (InputSystemException ex) {
            ex.printStackTrace();
            X3DLog.print(ex);
        }
    }

    @Deprecated
    public void setSoundDriver(SoundDriver soundDriver) {
        SoundProcessor.getInstance().setSoundDriver(soundDriver);
    }

    @Deprecated
    public SoundDriver getSoundDriver() {
        return SoundProcessor.getInstance().getSoundDriver();
    }

    @Override
    public Canvas3D addCanvas(Canvas3D canvas, View view) {
        _RNDR_PrivilegedAccess.addCanvas3D(canvas, this.getRenderer());
        view.addCanvas3D(canvas);
        if (this.firstCanvas == null) {
            this.firstCanvas = canvas;
            for (int i = 0; i < this.huds.size(); ++i) {
                ((HUD)this.huds.get(i)).connect(this.firstCanvas);
            }
        }
        this.canvasEnabledMap.put(canvas, true);
        return canvas;
    }

    @Override
    public Canvas3D addCanvas(Canvas3D canvas) {
        this.addCanvas(canvas, this.getView());
        return canvas;
    }

    @Override
    public Canvas3DWrapper addCanvas(Canvas3DWrapper canvasWrapper, View view) {
        this.addCanvas(canvasWrapper.getCanvas(), view);
        return canvasWrapper;
    }

    @Override
    public Canvas3DWrapper addCanvas(Canvas3DWrapper canvasWrapper) {
        this.addCanvas(canvasWrapper.getCanvas());
        return canvasWrapper;
    }

    @Override
    public void removeCanvas(Canvas3D canvas) {
        _RNDR_PrivilegedAccess.removeCanvas3D(canvas, this.getRenderer());
        if (canvas.getView() != null) {
            canvas.getView().removeCanvas3D(canvas);
        }
        this.canvasEnabledMap.remove(canvas);
        if (this.canvasEnabledMap.isEmpty()) {
            this.firstCanvas = null;
        }
    }

    @Override
    public void removeCanvas(Canvas3DWrapper canvasWrapper) {
        _RNDR_PrivilegedAccess.removeCanvas3D(canvasWrapper.getCanvas(), this.getRenderer());
        if (canvasWrapper.getCanvas().getView() != null) {
            canvasWrapper.getCanvas().getView().removeCanvas3D(canvasWrapper.getCanvas());
        }
    }

    @Override
    public void removeAllCanvas3Ds() {
        int nc = this.getRenderer().getNumberOfCanvas3Ds();
        for (int i = 0; i < nc; ++i) {
            Canvas3D canvas = _RNDR_PrivilegedAccess.removeCanvas3D(i, this.getRenderer());
            canvas.getView().removeCanvas3D(canvas);
        }
    }

    @Override
    public Canvas3D getCanvas() {
        if (this.firstCanvas == null) {
            return null;
        }
        return this.firstCanvas;
    }

    @Override
    public Canvas3D getCanvas(int index) {
        int k = 0;
        int n = this.getNumberOfViews();
        for (int i = 0; i < n; ++i) {
            View view = this.getView(i);
            int m = view.numCanvas3Ds();
            for (int j = 0; j < m; ++j) {
                Canvas3D canvas = view.getCanvas3D(j);
                if (k == index) {
                    return canvas;
                }
                ++k;
            }
        }
        return null;
    }

    @Override
    public void suspendCanvas(Canvas3D canvas) {
        if (this.canvasEnabledMap.containsKey(canvas)) {
            this.canvasEnabledMap.put(canvas, false);
        }
    }

    @Override
    public void suspendCanvas(Canvas3DWrapper canvasWrapper) {
        this.suspendCanvas(canvasWrapper.getCanvas());
    }

    @Override
    public void reviveCanvas(Canvas3D canvas) {
        if (!this.canvasEnabledMap.containsKey(canvas)) {
            this.addCanvas(canvas);
        } else {
            this.canvasEnabledMap.put(canvas, true);
        }
    }

    @Override
    public void reviveCanvas(Canvas3DWrapper canvasWrapper) {
        this.reviveCanvas(canvasWrapper.getCanvas());
    }

    @Override
    public boolean isCanvasAlive(Canvas3D canvas) {
        if (this.canvasEnabledMap.containsKey(canvas)) {
            return this.canvasEnabledMap.get(canvas);
        }
        return false;
    }

    @Override
    public boolean isCanvasAlive(Canvas3DWrapper canvasWrapper) {
        return this.isCanvasAlive(canvasWrapper.getCanvas());
    }

    public void setCanvasRenderPassMap(HashMap<Canvas3D, List<RenderPass>> canvasRenderPassMap) {
        this.canvasRenderPassMap = canvasRenderPassMap;
    }

    public void checkRenderPreferences() {
        int nv = this.getNumberOfViews();
        for (int i = 0; i < nv; ++i) {
            View view = this.getView(i);
            int nc = view.numCanvas3Ds();
            for (int j = 0; j < nc; ++j) {
                Canvas3D canvas = view.getCanvas3D(j);
                canvas.getPeer().beforeThreadChanged();
            }
        }
    }

    public void render(long nanoGameTime, long nanoFrameTime) {
        for (int i = 0; i < this.huds.size(); ++i) {
            __HUD_PrivilegedAccess.updateOperations((HUD)this.huds.get(i), nanoGameTime, nanoFrameTime);
        }
        int canvasesCount = 0;
        long frameId = -1L;
        SoundProcessor sp = SoundProcessor.getInstance();
        List<RenderPass> renderPasses = this.getRenderer().getRenderPasses();
        int numRP = renderPasses.size();
        int nv = this.getNumberOfViews();
        for (int v = 0; v < nv; ++v) {
            View view = this.getView(v);
            List<Canvas3D> canvases = view.getCanvas3Ds();
            for (int c = 0; c < canvases.size(); ++c) {
                Canvas3D canvas = canvases.get(c);
                if (!this.canvasAliveCheckSuppressed && !this.isCanvasAlive(canvas)) continue;
                frameId = this.canvasRenderPassMap == null ? this.getRenderer().renderOnce(canvas, nanoGameTime, nanoFrameTime) : this.getRenderer().renderOnce(this.canvasRenderPassMap.get(canvas), null, canvas, nanoGameTime, nanoFrameTime);
                ++canvasesCount;
            }
            for (int i = 0; i < numRP; ++i) {
                sp.processAll(renderPasses.get(i).getBranchGroup(), view, frameId);
            }
        }
        if (canvasesCount == 0) {
            System.err.println("No Canvas3D added to the environment!");
        }
    }

    public void render() {
        this.render(System.nanoTime(), -1L);
    }

    public void destroy() {
        int nv = this.getNumberOfViews();
        for (int i = 0; i < nv; ++i) {
            View view = this.getView(i);
            int nc = view.numCanvas3Ds();
            for (int j = 0; j < nc; ++j) {
                Canvas3D canvas = view.getCanvas3D(j);
                canvas.getPeer().destroy();
            }
        }
        SoundDriver soundDriver = SoundProcessor.getInstance().getSoundDriver();
        if (soundDriver != null) {
            soundDriver.shutdown();
        }
        if (TextureLoader.getInstance().getCache() != null) {
            TextureLoader.getInstance().getCache().clear();
        }
    }

    private Xith3DEnvironment(boolean headless, float eyePositionX, float eyePositionY, float eyePositionZ, float viewFocusX, float viewFocusY, float viewFocusZ, float vecUpX, float vecUpY, float vecUpZ, RenderLoop renderLoop) {
        super(new DefaultRenderer());
        this.getRenderer().setLayeredMode(true);
        if (!headless) {
            this.addView(new View(eyePositionX, eyePositionY, eyePositionZ, viewFocusX, viewFocusY, viewFocusZ, vecUpX, vecUpY, vecUpZ));
        }
        this.firstCanvas = null;
        this.canvasEnabledMap = new ConcurrentHashMap();
        if (renderLoop != null) {
            renderLoop.setXith3DEnvironment(this);
        }
        this.renderLoop = renderLoop;
        this.screenshotEngine = new EnvScreenshotEngineImpl(this);
        this.pickScheduler = new PickSchedulerImpl(this);
    }

    public Xith3DEnvironment(float eyePositionX, float eyePositionY, float eyePositionZ, float viewFocusX, float viewFocusY, float viewFocusZ, float vecUpX, float vecUpY, float vecUpZ, RenderLoop renderLoop) {
        this(false, eyePositionX, eyePositionY, eyePositionZ, viewFocusX, viewFocusY, viewFocusZ, vecUpX, vecUpY, vecUpZ, renderLoop);
    }

    public Xith3DEnvironment(float eyePositionX, float eyePositionY, float eyePositionZ, float viewFocusX, float viewFocusY, float viewFocusZ, float vecUpX, float vecUpY, float vecUpZ) {
        this(false, eyePositionX, eyePositionY, eyePositionZ, viewFocusX, viewFocusY, viewFocusZ, vecUpX, vecUpY, vecUpZ, null);
    }

    public Xith3DEnvironment(Tuple3f eyePosition, Tuple3f viewFocus, Tuple3f vecUp, RenderLoop renderLoop) {
        this(eyePosition == null || viewFocus == null || vecUp == null, eyePosition != null ? eyePosition.getX() : 0.0f, eyePosition != null ? eyePosition.getY() : 0.0f, eyePosition != null ? eyePosition.getZ() : 0.0f, viewFocus != null ? viewFocus.getX() : 0.0f, viewFocus != null ? viewFocus.getY() : 0.0f, viewFocus != null ? viewFocus.getZ() : 0.0f, vecUp != null ? vecUp.getX() : 0.0f, vecUp != null ? vecUp.getY() : 0.0f, vecUp != null ? vecUp.getZ() : 0.0f, renderLoop);
    }

    public Xith3DEnvironment(Tuple3f eyePosition, Tuple3f viewFocus, Tuple3f vecUp) {
        this(eyePosition, viewFocus, vecUp, null);
    }

    public Xith3DEnvironment(RenderLoop renderLoop) {
        this(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, renderLoop);
    }

    public Xith3DEnvironment() {
        this(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public static final Xith3DEnvironment createHeadless(RenderLoop renderLoop) {
        return new Xith3DEnvironment(null, null, null, renderLoop);
    }

    public static final Xith3DEnvironment createHeadless() {
        return new Xith3DEnvironment(null, null, null, null);
    }
}

