/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.celshading;

import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2D;

public abstract class CelShadingFactory {
    private static Texture2D texture = null;
    private static final PolygonAttributes outlinePolyAttribs = new PolygonAttributes(DrawMode.LINE, FaceCullMode.FRONT);
    private static final RenderingAttributes outlineRenderingAttribs = new RenderingAttributes();
    private static final ColoringAttributes outlineColoringAttribs;
    private static final LineAttributes outlineLineAttribs;

    public static final Texture2D getTexture() {
        if (texture == null) {
            texture = TextureLoader.getInstance().loadTexture(CelShadingFactory.class.getClassLoader().getResource("resources/org/xith3d/shaders/celshading/celshading.png"));
        }
        return texture;
    }

    public static final void setOutlineLineWidth(float width) {
        outlineLineAttribs.setLineWidth(Math.max(1.0f, width));
    }

    public static final float getOutlineLineWidth() {
        return outlineLineAttribs.getLineWidth();
    }

    public static final Shape3D createOutlineShape(Geometry geometry) {
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(outlinePolyAttribs);
        appearance.setRenderingAttributes(outlineRenderingAttribs);
        appearance.setColoringAttributes(outlineColoringAttribs);
        appearance.setLineAttributes(outlineLineAttribs);
        return new Shape3D(geometry, appearance);
    }

    protected Appearance getBaseAppearance() {
        Appearance app = new Appearance();
        app.setTexture(CelShadingFactory.getTexture());
        return app;
    }

    protected abstract Shape3D createMainShape(Geometry var1);

    public final void prepareForCelShading(Geometry geometry, GroupNode group) {
        group.addChild(this.createMainShape(geometry));
        group.addChild(CelShadingFactory.createOutlineShape(geometry));
    }

    static {
        outlineRenderingAttribs.setDepthTestFunction(RenderingAttributes.LESS_OR_EQUAL);
        outlineColoringAttribs = new ColoringAttributes(Colorf.BLACK, ColoringAttributes.NICEST);
        outlineLineAttribs = new LineAttributes(3.0f, LineAttributes.PATTERN_SOLID, false);
    }
}

