/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.celshading;

import org.openmali.spatial.bodies.Frustum;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.effects.celshading.CelShadingFactory;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.UpdatableNode;
import org.xith3d.scenegraph.View;

public class SimpleCelShadingFactory
extends CelShadingFactory {
    private static final Vector3f lightDirection = new Vector3f(0.0f, 0.0f, 1.0f);

    protected Shape3D createMainShape(Geometry geometry) {
        Appearance app = this.getBaseAppearance();
        return new CelShadingShape(geometry, app);
    }

    private static class CelShadingShape
    extends Shape3D
    implements UpdatableNode {
        private long nextUpdateTime = -1L;

        private static final void transposeTransform(Matrix4f m, Vector3f v) {
            v.set(m.m00() * v.getX() + m.m10() * v.getY() + m.m20() * v.getZ(), m.m01() * v.getX() + m.m11() * v.getY() + m.m21() * v.getZ(), m.m02() * v.getX() + m.m12() * v.getY() + m.m22() * v.getZ());
        }

        private static final void updateTextureCoordinates(Geometry geometry, Matrix4f matrix) {
            Vector3f tmpVector = Vector3f.fromPool();
            int numVertices = geometry.getVertexCount();
            for (int i = 0; i < numVertices; ++i) {
                geometry.getNormal(i, tmpVector);
                CelShadingShape.transposeTransform(matrix, tmpVector);
                tmpVector.normalize();
                float tmpShade = tmpVector.dot(lightDirection);
                if (tmpShade < 0.0f) {
                    tmpShade = 0.0f;
                }
                geometry.setTextureCoordinate(0, i, tmpShade, 0.0f);
            }
            Vector3f.toPool((Vector3f)tmpVector);
        }

        public boolean update(View view, Frustum frustum, long nanoTime, long nanoStep) {
            if (nanoTime >= this.nextUpdateTime) {
                Matrix4f m = Matrix4f.fromPool();
                this.getWorldTransform().get(m);
                m.invert();
                CelShadingShape.updateTextureCoordinates(this.getGeometry(), m);
                Matrix4f.toPool((Matrix4f)m);
                this.nextUpdateTime = nanoTime + 10000000L;
            }
            return true;
        }

        public CelShadingShape(Geometry geometry, Appearance appearance) {
            super(geometry, appearance);
        }
    }
}

