/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.shadows;

import org.jagatoo.opengl.enums.TexCoordGenMode;
import org.xith3d.effects.shadows.ShadowMappingFactory;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;

public class FixedFuncShadowMappingFactory
extends ShadowMappingFactory {
    private static TexCoordGeneration texGen = null;

    public static TexCoordGeneration getTexCoordGeneration() {
        if (texGen != null) {
            return texGen;
        }
        texGen = new TexCoordGeneration(TexCoordGenMode.EYE_LINEAR, TexCoordGeneration.CoordMode.TEXTURE_COORDINATES_4);
        texGen.setPlaneR(0.0f, 0.0f, 1.0f, 0.0f);
        texGen.setPlaneQ(0.0f, 0.0f, 0.0f, 1.0f);
        return texGen;
    }

    public void setShadowSoftness(int softness) {
        super.setShadowSoftness(softness);
    }

    public void onShadowReceiverStateChanged(Shape3D shape, boolean isShadowReceiver) {
        if (isShadowReceiver) {
            Appearance app = shape.getAppearance(true);
            app.setTexture(this.getShadowTextureUnit(), this.getShadowMap());
            TextureAttributes currTA = app.getTextureAttributes(this.getShadowTextureUnit());
            if (currTA == null) {
                app.setTextureAttributes(this.getShadowTextureUnit(), this.getShadowMapAttributes());
            } else if (currTA != this.getShadowMapAttributes()) {
                currTA.setCompareMode(this.getShadowMapAttributes().getCompareMode());
                currTA.setCompareFunction(this.getShadowMapAttributes().getCompareFunction());
            }
            app.setTexCoordGeneration(this.getShadowTextureUnit(), FixedFuncShadowMappingFactory.getTexCoordGeneration());
        } else {
            TextureUnit tu;
            Appearance app = shape.getAppearance();
            if (app != null && (tu = app.getTextureUnit(this.getShadowTextureUnit())) != null) {
                if (tu.getTexture() == this.getShadowMap() && tu.getTextureAttributes() == this.getShadowMapAttributes() && tu.getTexCoordGeneration() == FixedFuncShadowMappingFactory.getTexCoordGeneration()) {
                    app.setTextureUnit(this.getShadowTextureUnit(), null);
                } else {
                    if (tu.getTexture() == this.getShadowMap()) {
                        tu.setTexture((Texture)null);
                    }
                    if (tu.getTextureAttributes() == this.getShadowMapAttributes()) {
                        tu.setTextureAttributes(null);
                    }
                    if (tu.getTexCoordGeneration() == FixedFuncShadowMappingFactory.getTexCoordGeneration()) {
                        tu.setTexCoordGeneration(null);
                    }
                }
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (texGen != null) {
            texGen.setEnabled(enabled);
        }
    }

    public FixedFuncShadowMappingFactory() {
        this.setShadowQuality(this.getShadowQuality());
    }
}

