/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.shadows;

import java.io.IOException;
import java.net.URL;
import org.xith3d.effects.shadows.ShadowMappingFactory;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.Transform3D;

public class GLSLShadowMappingFactory
extends ShadowMappingFactory {
    private static GLSLContext shaderProgram = null;
    private final Transform3D cameraModelView = new Transform3D();

    protected void calculateTextureMatrix(float fovy, float aspect, float near, float far, Transform3D lightTransform, Transform3D viewTransform, Transform3D textureTransform) {
        super.calculateTextureMatrix(fovy, aspect, near, far, lightTransform, viewTransform, textureTransform);
        this.cameraModelView.set(viewTransform);
        textureTransform.mul(this.cameraModelView);
    }

    private static URL getResource(String resName) throws IOException {
        URL url = GLSLShadowMappingFactory.class.getClassLoader().getResource(resName);
        if (url == null) {
            throw new IOException("Could not find resource \"" + resName + "\".");
        }
        return url;
    }

    private GLSLContext getShaderProgram() throws IOException {
        if (shaderProgram != null) {
            return shaderProgram;
        }
        URL url = GLSLShadowMappingFactory.getResource("resources/org/xith3d/shaders/shadowmapping/shader.shadowmapping.glslvert");
        GLSLVertexShader vertexShader = GLSLShaderLoader.getInstance().loadVertexShader(url, new GLSLShaderLoader.InlineVariableMapping("shadowMapUnit", 3));
        url = GLSLShadowMappingFactory.getResource("resources/org/xith3d/shaders/shadowmapping/shader.shadowmapping.glslfrag");
        GLSLFragmentShader fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(url);
        shaderProgram = new GLSLContext(new GLSLShaderProgram(vertexShader, fragmentShader));
        GLSLParameters params = shaderProgram.getUniformParameters();
        params.setUniformVar("texture0", 0);
        params.setUniformVar("shadowMap", this.getShadowTextureUnit());
        params.setUniformVar("softness", this.getShadowSoftness());
        params.setUniformVar("soft_dist", 0.2f);
        return shaderProgram;
    }

    public void setShadowSoftness(int softness) {
        super.setShadowSoftness(softness);
        try {
            this.getShaderProgram().getUniformParameters().setUniformVar("softness", this.getShadowSoftness());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onShadowReceiverStateChanged(Shape3D shape, boolean isShadowReceiver) {
        if (isShadowReceiver) {
            Appearance app = shape.getAppearance(true);
            try {
                app.setShaderProgramContext(this.getShaderProgram());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            app.setTexture(this.getShadowTextureUnit(), this.getShadowMap());
            TextureAttributes currTA = app.getTextureAttributes(this.getShadowTextureUnit());
            if (currTA == null) {
                app.setTextureAttributes(this.getShadowTextureUnit(), this.getShadowMapAttributes());
            } else if (currTA != this.getShadowMapAttributes()) {
                currTA.setCompareMode(this.getShadowMapAttributes().getCompareMode());
                currTA.setCompareFunction(this.getShadowMapAttributes().getCompareFunction());
            }
        } else {
            TextureUnit tu;
            Appearance app = shape.getAppearance();
            if (app != null && (tu = app.getTextureUnit(this.getShadowTextureUnit())) != null) {
                if (tu.getTexture() == this.getShadowMap() && tu.getTextureAttributes() == this.getShadowMapAttributes() && tu.getTexCoordGeneration() == null) {
                    app.setTextureUnit(this.getShadowTextureUnit(), null);
                } else {
                    if (tu.getTexture() == this.getShadowMap()) {
                        tu.setTexture((Texture)null);
                    }
                    if (tu.getTextureAttributes() == this.getShadowMapAttributes()) {
                        tu.setTextureAttributes(null);
                    }
                }
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (shaderProgram != null) {
            shaderProgram.setEnabled(enabled);
        }
    }

    public GLSLShadowMappingFactory() {
        this.setShadowQuality(this.getShadowQuality());
    }
}

