/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.input.modules;

import java.util.ArrayList;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.xith3d.input.modules.ColliderCheckCallback;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionEngine;

public class SlidingColliderCheckCallback
implements ColliderCheckCallback {
    private final CollisionEngine collEngine;
    private CollideableGroup collGroup;
    private final ArrayList<Collision> collisions = new ArrayList();
    private final ArrayList<Collideable> walls = new ArrayList();
    private final ArrayList<Collision> collisions2 = new ArrayList();

    public final void setCollideableGroup(CollideableGroup collGroup) {
        this.collGroup = collGroup;
    }

    public final CollideableGroup getCollideableGroup() {
        return this.collGroup;
    }

    private static final void resolveCollision(Collision collision, Collideable avatarCollider) {
        Point3f pos = Point3f.fromPool();
        avatarCollider.getPosition((Tuple3f)pos);
        pos.add((TupleNf)collision.getScaledNormal());
        avatarCollider.setPosition((Tuple3f)pos);
        Point3f.toPool((Point3f)pos);
    }

    public boolean checkCollision(Collideable avatarCollider) {
        int i;
        if (avatarCollider == null || this.collGroup == null || !this.collEngine.isEnabled()) {
            return false;
        }
        this.collEngine.checkCollisions(avatarCollider, (Collideable)this.collGroup, false, this.collisions);
        if (this.collisions.size() == 0) {
            return false;
        }
        SlidingColliderCheckCallback.resolveCollision(this.collisions.get(0), avatarCollider);
        if (this.collisions.size() == 1) {
            return true;
        }
        this.walls.clear();
        for (i = 1; i < this.collisions.size(); ++i) {
            this.walls.add(this.collisions.get(i).getCollideable2());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            this.collEngine.checkCollisions(avatarCollider, this.walls.get(i), false, this.collisions2);
            if (this.collisions2.size() <= 0) continue;
            SlidingColliderCheckCallback.resolveCollision(this.collisions2.get(0), avatarCollider);
        }
        return true;
    }

    public SlidingColliderCheckCallback(CollisionEngine collEngine, CollideableGroup collGroup) {
        this.collEngine = collEngine;
        this.collGroup = collGroup;
    }
}

