/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.input.modules.fpih;

import org.openmali.spatial.AxisIndicator;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.input.modules.fpih.FPIHConfig;

public class FPIHMovementConstraints {
    private float maxAngleUp = FPIHConfig.DEFAULT_MAX_ANGLE_UP_DOWN;
    private float maxAngleDown = FPIHConfig.DEFAULT_MAX_ANGLE_UP_DOWN;
    private boolean fixedPlaneEnabled = false;

    public void setMaxAngleUp(float angle) {
        this.maxAngleUp = angle;
    }

    public final float getMaxAngleUp() {
        return this.maxAngleUp;
    }

    public void setMaxAngleDown(float angle) {
        this.maxAngleDown = angle;
    }

    public final float getMaxAngleDown() {
        return this.maxAngleDown;
    }

    public final void setMaxAngleUpDown(float angle) {
        this.setMaxAngleUp(angle);
        this.setMaxAngleDown(angle);
    }

    public void setFixedPlaneEnabled(boolean enabled) {
        this.fixedPlaneEnabled = enabled;
    }

    public final boolean getFixedPlaneEnabled() {
        return this.fixedPlaneEnabled;
    }

    public void applyRotationalConstraints(Tuple3f viewEuler, AxisIndicator upAxis) {
        float rotLeftRight = 0.0f;
        float rotUpDown = 0.0f;
        switch (upAxis) {
            case POSITIVE_X_AXIS: {
                rotLeftRight = viewEuler.getX();
                rotUpDown = viewEuler.getY();
                break;
            }
            case NEGATIVE_X_AXIS: {
                rotLeftRight = viewEuler.getX();
                rotUpDown = viewEuler.getY();
                break;
            }
            case POSITIVE_Y_AXIS: {
                rotLeftRight = viewEuler.getY();
                rotUpDown = viewEuler.getX();
                break;
            }
            case NEGATIVE_Y_AXIS: {
                rotLeftRight = viewEuler.getY();
                rotUpDown = viewEuler.getX();
                break;
            }
            case POSITIVE_Z_AXIS: {
                rotLeftRight = viewEuler.getZ();
                rotUpDown = viewEuler.getX() - 1.5707964f;
                break;
            }
            case NEGATIVE_Z_AXIS: {
                rotLeftRight = viewEuler.getZ();
                rotUpDown = viewEuler.getX() - 1.5707964f;
            }
        }
        rotLeftRight %= (float)Math.PI * 2;
        if (rotUpDown > this.maxAngleUp) {
            rotUpDown = this.maxAngleUp;
        } else if (rotUpDown < -this.maxAngleDown) {
            rotUpDown = -this.maxAngleDown;
        }
        switch (upAxis) {
            case POSITIVE_X_AXIS: {
                viewEuler.setX(rotLeftRight);
                viewEuler.setY(rotUpDown);
                break;
            }
            case NEGATIVE_X_AXIS: {
                viewEuler.setX(rotLeftRight);
                viewEuler.setY(rotUpDown);
                break;
            }
            case POSITIVE_Y_AXIS: {
                viewEuler.setY(rotLeftRight);
                viewEuler.setX(rotUpDown);
                break;
            }
            case NEGATIVE_Y_AXIS: {
                viewEuler.setY(rotLeftRight);
                viewEuler.setX(rotUpDown);
                break;
            }
            case POSITIVE_Z_AXIS: {
                viewEuler.setZ(rotLeftRight);
                viewEuler.setX(rotUpDown + 1.5707964f);
                break;
            }
            case NEGATIVE_Z_AXIS: {
                viewEuler.setZ(rotLeftRight);
                viewEuler.setX(rotUpDown + 1.5707964f);
            }
        }
    }

    public void applyMovementDeltaConstraints(Vector3f viewDeltaPosition, AxisIndicator upAxis) {
        if (this.fixedPlaneEnabled) {
            float speed = viewDeltaPosition.length();
            if (speed == 0.0f || Float.isNaN(speed) || Float.isInfinite(speed)) {
                viewDeltaPosition.setZero();
                return;
            }
            switch (upAxis) {
                case POSITIVE_X_AXIS: 
                case NEGATIVE_X_AXIS: {
                    viewDeltaPosition.setX(0.0f);
                    break;
                }
                case POSITIVE_Y_AXIS: 
                case NEGATIVE_Y_AXIS: {
                    viewDeltaPosition.setY(0.0f);
                    break;
                }
                case POSITIVE_Z_AXIS: 
                case NEGATIVE_Z_AXIS: {
                    viewDeltaPosition.setZ(0.0f);
                }
            }
            viewDeltaPosition.normalize();
            viewDeltaPosition.scale(speed);
        }
    }

    public void applyMovementConstraints(Tuple3f viewPosition, AxisIndicator upAxis) {
    }
}

