/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.GroupType;
import org.jagatoo.loaders.models._util.LoaderUtils;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.ac3d.AC3DPrototypeLoader;
import org.jagatoo.loaders.models.ase.AseReader;
import org.jagatoo.loaders.models.bsp.BSPPrototypeLoader;
import org.jagatoo.loaders.models.bsp.BSPTextureAnimator;
import org.jagatoo.loaders.models.md2.MD2File;
import org.jagatoo.loaders.models.md3.MD3File;
import org.jagatoo.loaders.models.md5.MD5AnimationReader;
import org.jagatoo.loaders.models.md5.MD5MeshReader;
import org.jagatoo.loaders.models.obj.OBJPrototypeLoader;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.models.conversion.XithAnimationFactory;
import org.xith3d.loaders.models.conversion.XithAppearanceFactory;
import org.xith3d.loaders.models.conversion.XithGeometryFactory;
import org.xith3d.loaders.models.conversion.XithNodeFactory;
import org.xith3d.loaders.models.util.specific.bsp.BSPTextureAnimatedShape;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Sound;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.SkyBox;

public class ModelLoader {
    public static final float SCALE = 1.0f;
    private static final XithAppearanceFactory appFactory = new XithAppearanceFactory();
    private static final XithNodeFactory nodeFactory = new XithNodeFactory();
    private static final XithAnimationFactory animFactory = new XithAnimationFactory();
    private static ModelLoader singletonInstance = null;
    public static final int LOAD_LIGHT_NODES = 1;
    public static final int LOAD_FOG_NODES = 2;
    public static final int LOAD_SOUND_NODES = 4;
    public static final int LOAD_CAMERAS = 8;
    public static final int LOAD_SUB_MODELS = 16;
    public static final int CONVERT_Z_UP_TO_Y_UP_IF_EXPECTED = 32;
    public static final int ALWAYS_CONVERT_Z_UP_TO_Y_UP = 64;
    public static final int DEFAULT_FLAGS = -65;
    private int loadFlags;

    public final void setFlags(int flags) {
        this.loadFlags = flags;
    }

    public final int getFlags() {
        return this.loadFlags;
    }

    public final void setFlag(int flag, boolean enable) {
        this.loadFlags = enable ? (this.loadFlags |= flag) : (this.loadFlags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.loadFlags & flag) > 0;
    }

    protected SourceModelType extractModelType(URL url, String filename) {
        if (filename.endsWith(".ac")) {
            return SourceModelType.AC3D;
        }
        if (filename.endsWith(".ase")) {
            return SourceModelType.ASE;
        }
        if (filename.endsWith(".bsp")) {
            return SourceModelType.BSP;
        }
        if (filename.endsWith(".cfg")) {
            return SourceModelType.CAL3D;
        }
        if (filename.endsWith(".dae")) {
            return SourceModelType.COLLADA;
        }
        if (filename.endsWith(".md2")) {
            return SourceModelType.MD2;
        }
        if (filename.endsWith(".md2")) {
            return SourceModelType.MD2;
        }
        if (filename.endsWith(".md3")) {
            return SourceModelType.MD3;
        }
        if (filename.endsWith(".md5mesh")) {
            return SourceModelType.MD5;
        }
        if (filename.endsWith(".obj")) {
            return SourceModelType.OBJ;
        }
        if (filename.endsWith(".3ds")) {
            return SourceModelType.TDS;
        }
        if (url == null) {
            throw new Error("Can't load the model file \"" + filename + "\".");
        }
        throw new Error("Can't load the model file \"" + url.toString() + "\".");
    }

    protected final SourceModelType extractModelType(URL url) {
        return this.extractModelType(url, url.getFile().toLowerCase());
    }

    protected final SourceModelType extractModelType(String filename) {
        return this.extractModelType(null, filename);
    }

    protected Model loadModel(URL url, String filenameBase, SourceModelType modelType, URL baseURL, String skin, float scale, int flags, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, Model model) throws IOException, IncorrectFormatException, ParsingException {
        boolean convertZup2Yup = modelType.getConvertFlag(flags);
        switch (modelType) {
            case AC3D: {
                AC3DPrototypeLoader.load((InputStream)url.openStream(), (URL)baseURL, (AppearanceFactory)appFactory, (GeometryFactory)geomFactory, (NodeFactory)nodeFactory, (boolean)true, (NamedObject)model, (SpecialItemsHandler)siHandler);
                break;
            }
            case ASE: {
                AseReader.load((InputStream)url.openStream(), (URL)baseURL, (AppearanceFactory)appFactory, (GeometryFactory)geomFactory, (boolean)convertZup2Yup, (float)scale, (NodeFactory)nodeFactory, (AnimationFactory)animFactory, (SpecialItemsHandler)siHandler, (NamedObject)model);
                break;
            }
            case BSP: {
                BSPPrototypeLoader.load((InputStream)url.openStream(), (String)filenameBase, (URL)baseURL, (GeometryFactory)geomFactory, (boolean)true, (float)0.03f, (AppearanceFactory)appFactory, (NodeFactory)nodeFactory, (NamedObject)model, (GroupType)GroupType.BSP_TREE, (SpecialItemsHandler)siHandler);
                break;
            }
            case CAL3D: {
                break;
            }
            case COLLADA: {
                break;
            }
            case MD2: {
                MD2File.load((InputStream)url.openStream(), (URL)baseURL, (AppearanceFactory)appFactory, (String)skin, (GeometryFactory)geomFactory, (boolean)convertZup2Yup, (float)scale, (NodeFactory)nodeFactory, (AnimationFactory)animFactory, (SpecialItemsHandler)siHandler, (NamedObject)model);
                break;
            }
            case MD3: {
                MD3File.load((InputStream)url.openStream(), (URL)baseURL, (AppearanceFactory)appFactory, (GeometryFactory)geomFactory, (boolean)convertZup2Yup, (float)scale, (NodeFactory)nodeFactory, (AnimationFactory)animFactory, (SpecialItemsHandler)siHandler, (NamedObject)model);
                break;
            }
            case MD5: {
                Object[][][] boneWeights = MD5MeshReader.load((InputStream)url.openStream(), (URL)baseURL, (AppearanceFactory)appFactory, (String)skin, (GeometryFactory)geomFactory, (boolean)convertZup2Yup, (float)scale, (NodeFactory)nodeFactory, (AnimationFactory)animFactory, (SpecialItemsHandler)siHandler, (NamedObject)model);
                ((SpecialItemsHandlerImpl)siHandler).flush();
                List<URL> animResources = new ResourceLocator(baseURL).findAllResources("md5anim", true, false);
                for (URL animURL : animResources) {
                    String filename = LoaderUtils.extractFilenameWithoutExt((URL)animURL);
                    MD5AnimationReader.load((InputStream)animURL.openStream(), (String)filename, (URL)baseURL, (AppearanceFactory)appFactory, (GeometryFactory)geomFactory, (boolean)convertZup2Yup, (float)scale, (NodeFactory)nodeFactory, (NamedObject[])model.getShapes(), (Object[][][])boneWeights, (AnimationFactory)animFactory, (SpecialItemsHandler)siHandler, (NamedObject)model);
                }
                break;
            }
            case MS3D: {
                break;
            }
            case OBJ: {
                Group rootGroup = model;
                if (scale != 1.0f) {
                    TransformGroup scaleGroup = new TransformGroup();
                    scaleGroup.getTransform().setScale(scale);
                    model.addChild(scaleGroup);
                    model.setMainGroup(scaleGroup);
                    rootGroup = scaleGroup;
                }
                OBJPrototypeLoader.load((InputStream)url.openStream(), (URL)baseURL, (AppearanceFactory)appFactory, (String)skin, (GeometryFactory)geomFactory, (boolean)convertZup2Yup, (float)scale, (NodeFactory)nodeFactory, (SpecialItemsHandler)siHandler, (NamedObject)rootGroup);
                break;
            }
            case TDS: {
                TDSFile.load((InputStream)url.openStream(), (URL)baseURL, (AppearanceFactory)appFactory, (GeometryFactory)geomFactory, (boolean)convertZup2Yup, (NodeFactory)nodeFactory, (AnimationFactory)animFactory, (SpecialItemsHandler)siHandler, (NamedObject)model);
            }
        }
        return model;
    }

    public Model loadModel(URL url, String filenameBase, URL baseURL, String skin, float scale, int flags) throws IOException, IncorrectFormatException, ParsingException {
        SourceModelType modelType = this.extractModelType(url);
        Model model = new Model();
        model.setName(filenameBase);
        XithGeometryFactory geomFactory = new XithGeometryFactory(modelType.getDefaultOptimization());
        SpecialItemsHandlerImpl siHandler = new SpecialItemsHandlerImpl(model);
        model = this.loadModel(url, filenameBase, modelType, baseURL, skin, scale, flags, appFactory, geomFactory, nodeFactory, animFactory, siHandler, model);
        siHandler.flush();
        model.updateBounds(false);
        return model;
    }

    public final Model loadModel(URL url, String skin, float scale, int flags) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(url, LoaderUtils.extractFilenameWithoutExt((URL)url), LoaderUtils.extractBaseURL((URL)url), skin, scale, flags);
    }

    public final Model loadModel(URL url, float scale, int flags) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(url, null, scale, flags);
    }

    public final Model loadModel(String filename, String skin, float scale, int flags) throws IOException, IncorrectFormatException, ParsingException {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        return this.loadModel(file.toURI().toURL(), skin, scale, flags);
    }

    public final Model loadModel(String filename, float scale, int flags) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(filename, null, scale, flags);
    }

    public final Model loadModel(URL url, String skin, float scale) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(url, skin, scale, this.getFlags());
    }

    public final Model loadModel(URL url, float scale) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(url, scale, this.getFlags());
    }

    public final Model loadModel(String filename, String skin, float scale) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(filename, skin, scale, this.getFlags());
    }

    public final Model loadModel(String filename, float scale) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(filename, null, scale, this.getFlags());
    }

    public final Model loadModel(URL url, String skin) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(url, skin, 1.0f, this.getFlags());
    }

    public final Model loadModel(URL url) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(url, null);
    }

    public final Model loadModel(String filename, String skin) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(filename, skin, 1.0f, this.getFlags());
    }

    public final Model loadModel(String filename) throws IOException, IncorrectFormatException, ParsingException {
        return this.loadModel(filename, null);
    }

    protected ModelLoader(int flags) {
        this.loadFlags = flags;
    }

    protected ModelLoader() {
        this(-65);
    }

    public static ModelLoader getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ModelLoader();
        }
        return singletonInstance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SourceModelType {
        AC3D(false, Geometry.Optimization.USE_DISPLAY_LISTS),
        ASE(true, Geometry.Optimization.USE_DISPLAY_LISTS),
        BSP(true, Geometry.Optimization.USE_DISPLAY_LISTS),
        CAL3D(false, Geometry.Optimization.NONE),
        COLLADA(false, Geometry.Optimization.NONE),
        MD2(true, Geometry.Optimization.NONE),
        MD3(true, Geometry.Optimization.NONE),
        MD5(true, Geometry.Optimization.NONE),
        MS3D(false, Geometry.Optimization.NONE),
        OBJ(false, Geometry.Optimization.USE_DISPLAY_LISTS),
        TDS(true, Geometry.Optimization.USE_DISPLAY_LISTS);

        private final boolean hasDefaultZUp;
        private final Geometry.Optimization defaultOptimization;

        public final boolean hasDefaultZUp() {
            return this.hasDefaultZUp;
        }

        public final boolean getConvertFlag(int flags) {
            if ((flags & 0x40) != 0) {
                return true;
            }
            if ((flags & 0x20) != 0) {
                return this.hasDefaultZUp;
            }
            return false;
        }

        public final Geometry.Optimization getDefaultOptimization() {
            return this.defaultOptimization;
        }

        private SourceModelType(boolean hasDefaultZUp, Geometry.Optimization defaultOptimization) {
            this.hasDefaultZUp = hasDefaultZUp;
            this.defaultOptimization = defaultOptimization;
        }
    }

    protected static final class SpecialItemsHandlerImpl
    implements SpecialItemsHandler {
        private final Model model;
        private ArrayList<TransformGroup> nestedTransforms = null;
        private HashSet<TransformGroup> nestedTransformsSet = null;
        private ArrayList<Shape3D> shapes = new ArrayList();
        private ArrayList<Light> lights = null;
        private ArrayList<Fog> fogs = null;
        private ArrayList<Sound> sounds = null;
        private ArrayList<View> cameras = null;
        private ArrayList<Matrix4f> spawnTransforms = null;
        private ArrayList<TransformGroup> mountTransforms = null;
        private ArrayList<ModelAnimation> animations = null;

        public void addSpecialItem(SpecialItemsHandler.SpecialItemType type, String name, Object item) {
            switch (type) {
                case MAIN_GROUP: {
                    this.model.setMainGroup((GroupNode)item);
                    if (name == null || name.length() <= 0) break;
                    this.model.addNamedObject(name, (NamedObject)item);
                    break;
                }
                case SHAPE: {
                    this.shapes.add((Shape3D)item);
                    if (name == null || name.length() <= 0) break;
                    this.model.addNamedObject(name, (NamedObject)item);
                    break;
                }
                case SPAWN_TRANSFORM: {
                    if (this.spawnTransforms == null) {
                        this.spawnTransforms = new ArrayList();
                    }
                    this.spawnTransforms.add((Matrix4f)item);
                    break;
                }
                case MOUNT_TRANSFORM: {
                    TransformGroup mt = new TransformGroup((Matrix4f)item);
                    mt.setName(name);
                    if (this.mountTransforms == null) {
                        this.mountTransforms = new ArrayList();
                    }
                    this.mountTransforms.add(mt);
                    break;
                }
                case NESTED_TRANSFORM: {
                    if (this.nestedTransformsSet == null) {
                        this.nestedTransformsSet = new HashSet();
                    }
                    if (this.nestedTransforms == null) {
                        this.nestedTransforms = new ArrayList();
                    }
                    if (this.nestedTransformsSet.contains(item)) break;
                    this.nestedTransformsSet.add((TransformGroup)item);
                    this.nestedTransforms.add((TransformGroup)item);
                    if (name == null || name.length() <= 0) break;
                    this.model.addNamedObject(name, (NamedObject)item);
                    break;
                }
                case ITEM: {
                    break;
                }
                case SUB_MODEL: {
                    break;
                }
                case LIGHT: {
                    if (this.lights == null) {
                        this.lights = new ArrayList();
                    }
                    this.lights.add((Light)item);
                    if (name == null || name.length() <= 0) break;
                    this.model.addNamedObject(name, (NamedObject)item);
                    break;
                }
                case FOG: {
                    if (this.fogs == null) {
                        this.fogs = new ArrayList();
                    }
                    this.fogs.add((Fog)item);
                    if (name == null || name.length() <= 0) break;
                    this.model.addNamedObject(name, (NamedObject)item);
                    break;
                }
                case SOUND: {
                    if (this.sounds == null) {
                        this.sounds = new ArrayList();
                    }
                    this.sounds.add((Sound)item);
                    if (name == null || name.length() <= 0) break;
                    this.model.addNamedObject(name, (NamedObject)item);
                    break;
                }
                case SKYBOX: {
                    this.model.setSkyBox((SkyBox)item);
                    if (name == null || name.length() <= 0) break;
                    this.model.addNamedObject(name, (NamedObject)item);
                    break;
                }
                case NAMED_OBJECT: {
                    this.model.addNamedObject(name, (NamedObject)item);
                }
            }
        }

        public NamedObject createTextureAnimator(BSPTextureAnimator animator, NamedObject shapeObj) {
            Shape3D shape = (Shape3D)shapeObj;
            BSPTextureAnimatedShape animatedShape = new BSPTextureAnimatedShape(shape.getGeometry(), shape.getAppearance(), animator);
            animatedShape.setName(shape.getName());
            return animatedShape;
        }

        public void addAnimation(Object animation) {
            if (this.animations == null) {
                this.animations = new ArrayList();
            }
            this.animations.add((ModelAnimation)animation);
        }

        public void flush() {
            if (this.nestedTransforms != null) {
                this.model.setNestedTransforms(this.nestedTransforms.toArray(new TransformGroup[this.nestedTransforms.size()]));
                this.nestedTransforms = null;
                this.nestedTransformsSet = null;
            }
            this.model.setShapes(this.shapes.toArray(new Shape3D[this.shapes.size()]));
            this.shapes.clear();
            if (this.lights != null) {
                this.model.setLights(this.lights.toArray(new Light[this.lights.size()]));
                this.lights = null;
            }
            if (this.fogs != null) {
                this.model.setFogs(this.fogs.toArray(new Fog[this.fogs.size()]));
                this.fogs = null;
            }
            if (this.sounds != null) {
                this.model.setSounds(this.sounds.toArray(new Sound[this.sounds.size()]));
                this.sounds = null;
            }
            if (this.cameras != null) {
                this.model.setCameras(this.cameras.toArray(new View[this.cameras.size()]));
                this.cameras = null;
            }
            if (this.animations != null) {
                this.model.setAnimations(this.animations.toArray(new ModelAnimation[this.animations.size()]));
                this.animations = null;
            }
            if (this.mountTransforms != null) {
                this.model.setMountTransforms(this.mountTransforms.toArray(new TransformGroup[this.mountTransforms.size()]));
                this.mountTransforms = null;
            }
            if (this.spawnTransforms != null) {
                this.model.setSpawnTransforms(this.spawnTransforms.toArray(new Matrix4f[this.spawnTransforms.size()]));
                this.spawnTransforms = null;
            }
        }

        public SpecialItemsHandlerImpl(Model model) {
            this.model = model;
        }
    }
}

