/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.animations;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationType;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.loaders.models.animations.MeshTransformKeyFrame;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshTransformKeyFrameController
extends KeyFrameController {
    private final TransformGroup tg;

    public final MeshTransformKeyFrame getFrame(int index) {
        return (MeshTransformKeyFrame)this.getKeyFrame(index);
    }

    @Override
    public final TransformGroup getTarget() {
        return this.tg;
    }

    @Override
    protected void updateTarget(float absAnimTime, int baseFrameIndex, int nextFrameIndex, float alpha, ModelAnimation animation) {
        int i;
        if (this.getNumFrames() <= 1) {
            MeshTransformKeyFrame frame = this.getFrame(0);
            this.tg.getTransform().set(frame.getTransform());
            this.tg.updateTransform();
            return;
        }
        float time = absAnimTime / animation.getDuration();
        MeshTransformKeyFrame prevFrame = null;
        MeshTransformKeyFrame nextFrame = null;
        for (i = 0; i < this.getNumFrames(); ++i) {
            prevFrame = this.getFrame(i);
            if (i < this.getNumFrames() - 1) {
                nextFrame = this.getFrame(i + 1);
                if (!(time >= prevFrame.getTime()) || !(time < nextFrame.getTime())) continue;
                break;
            }
            nextFrame = this.getFrame(0);
            break;
        }
        float deltaTime = nextFrame.getTime() - prevFrame.getTime();
        if (i == this.getNumFrames() - 1) {
            deltaTime = 1.0f - prevFrame.getTime();
        }
        float delta = (time - prevFrame.getTime()) / deltaTime;
        Transform3D form = new Transform3D();
        Matrix4f m = Matrix4f.fromPool();
        m.interpolate(prevFrame.getTransform(), nextFrame.getTransform(), delta, false);
        m.m33(1.0f);
        form.set(m);
        this.tg.setTransform(form);
    }

    @Override
    public MeshTransformKeyFrameController sharedCopy(Map<String, NamedObject> namedObjects) {
        String tgName = this.tg.getName();
        TransformGroup newTG = (TransformGroup)namedObjects.get(tgName);
        if (newTG == null) {
            throw new Error("Can't clone this AnimationController!");
        }
        return new MeshTransformKeyFrameController((MeshTransformKeyFrame[])this.getKeyFrames(), newTG);
    }

    public MeshTransformKeyFrameController(MeshTransformKeyFrame[] frames, TransformGroup tg) {
        super(AnimationType.MESH_TRANSFORM, frames);
        this.tg = tg;
    }
}

