/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.conversion;

import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.models.animations.Bone;
import org.xith3d.loaders.models.animations.BoneAnimationKeyFrame;
import org.xith3d.loaders.models.animations.BoneAnimationKeyFrameController;
import org.xith3d.loaders.models.animations.BoneWeight;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.loaders.models.animations.MeshDeformationKeyFrame;
import org.xith3d.loaders.models.animations.MeshDeformationKeyFrameController;
import org.xith3d.loaders.models.animations.MeshTransformKeyFrame;
import org.xith3d.loaders.models.animations.MeshTransformKeyFrameController;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransformGroup;

public class XithAnimationFactory
implements AnimationFactory {
    public final NamedObject createBone(NamedObject parentBone, String name, Vector3f translation, Quaternion4f rotation, Tuple3f scale) {
        return new Bone((Bone)parentBone, name, translation, rotation, scale);
    }

    public final NamedObject createBone(NamedObject parentBone, String name, Matrix4f transformation) {
        return new Bone((Bone)parentBone, name, transformation);
    }

    public final Object createBoneAnimationKeyFrame(NamedObject[] bones) {
        return new BoneAnimationKeyFrame((Bone[])bones);
    }

    public final Object createBoneWeight(int boneIndex, float weight, Vector3f offset) {
        return new BoneWeight(boneIndex, weight, offset);
    }

    public final Object createBoneAnimationKeyFrameController(Object[] keyFrames, Object[][] boneWeights, NamedObject target) {
        return new BoneAnimationKeyFrameController((BoneAnimationKeyFrame[])keyFrames, (BoneWeight[][])boneWeights, (Shape3D)target);
    }

    public final Object createMeshDeformationKeyFrame(float[] coords, float[] normals) {
        return new MeshDeformationKeyFrame(coords, normals);
    }

    public final Object createMeshDeformationKeyFrameController(Object[] keyFrames, NamedObject target) {
        return new MeshDeformationKeyFrameController((MeshDeformationKeyFrame[])keyFrames, (Shape3D)target);
    }

    public final Object createMeshTransformKeyFrame(float time, Vector3f translation, Quaternion4f rotation, Tuple3f scale) {
        Matrix4f transform = new Matrix4f();
        Matrix4f tmp = Matrix4f.fromPool();
        transform.set((Tuple3f)translation);
        tmp.set(rotation);
        transform.mul(tmp);
        tmp.setIdentity();
        tmp.m00(scale.getX());
        tmp.m11(scale.getY());
        tmp.m22(scale.getZ());
        transform.mul(tmp);
        Matrix4f.toPool((Matrix4f)tmp);
        return new MeshTransformKeyFrame(time, transform);
    }

    public final Object createMeshTransformKeyFrame(float time, Vector3f translation, AxisAngle3f rotation, Tuple3f scale) {
        Matrix4f transform = new Matrix4f();
        Matrix4f tmp = Matrix4f.fromPool();
        transform.set((Tuple3f)translation);
        tmp.set(rotation);
        transform.mul(tmp);
        tmp.setIdentity();
        tmp.m00(scale.getX());
        tmp.m11(scale.getY());
        tmp.m22(scale.getZ());
        transform.mul(tmp);
        Matrix4f.toPool((Matrix4f)tmp);
        return new MeshTransformKeyFrame(time, transform);
    }

    public final Object createMeshTransformKeyFrame(float time, Vector3f translation, Matrix3f rotation, Tuple3f scale) {
        Matrix4f transform = new Matrix4f();
        Matrix4f tmp = Matrix4f.fromPool();
        transform.set((Tuple3f)translation);
        tmp.set(rotation);
        transform.mul(tmp);
        tmp.setIdentity();
        tmp.m00(scale.getX());
        tmp.m11(scale.getY());
        tmp.m22(scale.getZ());
        transform.mul(tmp);
        Matrix4f.toPool((Matrix4f)tmp);
        return new MeshTransformKeyFrame(time, transform);
    }

    public final Object createMeshTransformKeyFrame(float time, Matrix4f transform) {
        return new MeshTransformKeyFrame(time, transform);
    }

    public void transformMeshTransformKeyFrame(Matrix4f transform, Object frameObj) {
        MeshTransformKeyFrame frame = (MeshTransformKeyFrame)frameObj;
        frame.getTransform().mul(transform, frame.getTransform());
    }

    public final void transformMeshTransformKeyFrames(Matrix4f transform, Object[] frames) {
        for (int i = 0; i < frames.length; ++i) {
            MeshTransformKeyFrame frame = (MeshTransformKeyFrame)frames[i];
            frame.getTransform().mul(transform, frame.getTransform());
        }
    }

    public final Object createMeshTransformKeyFrameController(Object[] keyFrames, NamedObject target) {
        return new MeshTransformKeyFrameController((MeshTransformKeyFrame[])keyFrames, (TransformGroup)target);
    }

    public Object createAnimation(String name, int numFrames, float fps, Object[] controllers, Matrix4f[][] mountTransformFrames) {
        ModelAnimation animation = new ModelAnimation(name, numFrames, fps, (KeyFrameController[])controllers);
        animation.setMountTransformFrames(mountTransformFrames);
        return animation;
    }
}

