/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.conversion;

import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.TexCoord4f;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedGeometryArray;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleFanArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleFanArray;
import org.xith3d.scenegraph.TriangleStripArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XithGeometryFactory
implements GeometryFactory {
    private Geometry.Optimization optimization;

    public final void setOptimization(Geometry.Optimization optimization) {
        this.optimization = optimization;
    }

    public final Geometry.Optimization getOptimization() {
        return this.optimization;
    }

    private final NamedObject createGeometry(String name, GeometryFactory.GeometryType type, boolean interleaved, int coordSize, int numVertices, int numIndices, int[] numStrips, int features, boolean colorAlpha, int[] tuSizes, int[] vaSizes) {
        Geometry geom;
        switch (type) {
            case TRIANGLE_ARRAY: {
                geom = new TriangleArray(coordSize, numVertices);
                break;
            }
            case TRIANGLE_STRIP_ARRAY: {
                if (numStrips == null) {
                    numStrips = new int[]{numVertices};
                }
                geom = new TriangleStripArray(coordSize, numVertices, numStrips);
                break;
            }
            case INDEXED_TRIANGLE_ARRAY: {
                geom = new IndexedTriangleArray(coordSize, numVertices, numIndices);
                break;
            }
            case INDEXED_TRIANGLE_STRIP_ARRAY: {
                if (numStrips == null) {
                    numStrips = new int[]{numIndices};
                }
                geom = new IndexedTriangleStripArray(coordSize, numVertices, numIndices, numStrips);
                break;
            }
            case TRIANGLE_FAN_ARRAY: {
                if (numStrips == null) {
                    geom = new TriangleFanArray(coordSize, numVertices);
                    break;
                }
                geom = new TriangleFanArray(coordSize, numVertices, numStrips);
                break;
            }
            case INDEXED_TRIANGLE_FAN_ARRAY: {
                if (numStrips == null) {
                    numStrips = new int[]{numIndices};
                }
                geom = new IndexedTriangleFanArray(coordSize, numVertices, numIndices, numStrips);
                break;
            }
            default: {
                throw new Error("Unsupported Geometry type " + type);
            }
        }
        geom.setName(name);
        if (interleaved) {
            geom.makeInterleaved(features, colorAlpha, tuSizes, vaSizes);
        }
        geom.setOptimization(this.optimization);
        return geom;
    }

    public final NamedObject createGeometry(String name, GeometryFactory.GeometryType type, int coordSize, int numVertices, int numIndices, int[] numStrips) {
        return this.createGeometry(name, type, false, coordSize, numVertices, numIndices, numStrips, 0, false, null, null);
    }

    public final NamedObject createInterleavedGeometry(String name, GeometryFactory.GeometryType type, int coordSize, int numVertices, int numIndices, int[] numStrips, int features, boolean colorAlpha, int[] tuSizes, int[] vaSizes) {
        return this.createGeometry(name, type, true, coordSize, numVertices, numIndices, numStrips, features, colorAlpha, tuSizes, vaSizes);
    }

    public final void setCoordinate(NamedObject geometry, GeometryFactory.GeometryType type, int vertexIndex, float x, float y, float z) {
        ((Geometry)geometry).setCoordinate(vertexIndex, x, y, z);
    }

    public final void setCoordinates(NamedObject geometry, GeometryFactory.GeometryType type, int vertexIndex, float[] data, int offset, int num) {
        ((Geometry)geometry).setCoordinates(vertexIndex, data, offset / ((Geometry)geometry).getCoordinatesSize(), num);
    }

    public final void setCoordinates(NamedObject geometry, GeometryFactory.GeometryType type, int vertexIndex, Point3f[] data, int offset, int num) {
        for (int i = 0; i < num; ++i) {
            ((Geometry)geometry).setCoordinate(vertexIndex + i, (Tuple3f)data[offset + i]);
        }
    }

    public final void setNormal(NamedObject geometry, GeometryFactory.GeometryType type, int vertexIndex, float x, float y, float z) {
        ((Geometry)geometry).setNormal(vertexIndex, x, y, z);
    }

    public final void setNormals(NamedObject geometry, GeometryFactory.GeometryType type, int vertexIndex, float[] data, int offset, int num) {
        ((Geometry)geometry).setNormals(vertexIndex, data, offset / 3, num);
    }

    public final void setNormals(NamedObject geometry, GeometryFactory.GeometryType type, int vertexIndex, Vector3f[] data, int offset, int num) {
        for (int i = 0; i < num; ++i) {
            ((Geometry)geometry).setNormal(vertexIndex + i, data[offset + i]);
        }
    }

    public final void setTexCoord(NamedObject geometry, GeometryFactory.GeometryType type, int textureUnit, int vertexIndex, float s, float t) {
        ((Geometry)geometry).setTextureCoordinate(textureUnit, vertexIndex, s, t);
    }

    public final void setTexCoords(NamedObject geometry, GeometryFactory.GeometryType type, int textureUnit, int texCoordSize, int vertexIndex, float[] data, int offset, int num) {
        ((Geometry)geometry).setTextureCoordinates(textureUnit, vertexIndex, texCoordSize, data, offset / texCoordSize, num);
    }

    public final void setTexCoords(NamedObject geometry, GeometryFactory.GeometryType type, int textureUnit, int texCoordSize, int vertexIndex, TexCoordf<?>[] data, int offset, int num) {
        switch (texCoordSize) {
            case 1: {
                break;
            }
            case 2: {
                for (int i = 0; i < num; ++i) {
                    ((Geometry)geometry).setTextureCoordinate(textureUnit, vertexIndex + i, (TexCoordf<?>)((TexCoord2f)data[offset + i]));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < num; ++i) {
                    ((Geometry)geometry).setTextureCoordinate(textureUnit, vertexIndex + i, (TexCoordf<?>)((TexCoord3f)data[offset + i]));
                }
                break;
            }
            case 4: {
                for (int i = 0; i < num; ++i) {
                    ((Geometry)geometry).setTextureCoordinate(textureUnit, vertexIndex + i, (TexCoordf<?>)((TexCoord4f)data[offset + i]));
                }
                break;
            }
        }
    }

    public final void setColors(NamedObject geometry, GeometryFactory.GeometryType type, int colorSize, int vertexIndex, float[] data, int offset, int num) {
        ((Geometry)geometry).setColors(vertexIndex, colorSize, data, offset / colorSize, num);
    }

    public final void setColors(NamedObject geometry, GeometryFactory.GeometryType type, int colorSize, int vertexIndex, Colorf[] data, int offset, int num) {
        for (int i = 0; i < num; ++i) {
            ((Geometry)geometry).setColor(vertexIndex + i, data[offset + i]);
        }
    }

    public final void setVertexAttribs(NamedObject geometry, GeometryFactory.GeometryType type, int attribIndex, int attribSize, int vertexIndex, float[] data, int offset, int num) {
        ((Geometry)geometry).setVertexAttributes(attribIndex, vertexIndex, data, attribSize, offset / attribSize, num);
    }

    public final void setIndex(NamedObject geometry, GeometryFactory.GeometryType type, int vertexIndex, int[] data, int offset, int num) {
        switch (type) {
            case TRIANGLE_ARRAY: 
            case TRIANGLE_STRIP_ARRAY: 
            case TRIANGLE_FAN_ARRAY: {
                throw new Error("The used GeometryType doesn't have an index!");
            }
            case INDEXED_TRIANGLE_ARRAY: 
            case INDEXED_TRIANGLE_STRIP_ARRAY: 
            case INDEXED_TRIANGLE_FAN_ARRAY: {
                if (vertexIndex == 0 && offset == 0 && num == data.length) {
                    ((IndexedGeometryArray)geometry).setIndex(data);
                } else {
                    for (int i = 0; i < num; ++i) {
                        ((IndexedGeometryArray)geometry).setIndex(vertexIndex + i, data[offset + i]);
                    }
                }
                return;
            }
        }
        throw new Error("Unsupported Geometry type " + type);
    }

    public final void finalizeGeometry(NamedObject geometry, GeometryFactory.GeometryType type, int initialVertexIndex, int numValidVertices, int initialIndexIndex, int numValidIndices) {
        ((Geometry)geometry).setInitialVertexIndex(initialVertexIndex);
        ((Geometry)geometry).setValidVertexCount(numValidVertices);
        switch (type) {
            case INDEXED_TRIANGLE_ARRAY: 
            case INDEXED_TRIANGLE_STRIP_ARRAY: 
            case INDEXED_TRIANGLE_FAN_ARRAY: {
                ((IndexedGeometryArray)geometry).setInitialIndexIndex(initialIndexIndex);
                ((IndexedGeometryArray)geometry).setValidIndexCount(numValidIndices);
            }
        }
    }

    public XithGeometryFactory(Geometry.Optimization optimization) {
        this.optimization = optimization;
    }
}

