/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.cal3d.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.xith3d.loaders.models.impl.cal3d.Cal3dModel;

public class AnimControlPanel
extends JPanel {
    private static final long serialVersionUID = 6992357433479133417L;
    private Cal3dModel character;
    private String id;
    private JButton actionButton;
    private JButton bindKeyButton;
    private JSlider blendSlider;
    private JLabel idLabel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel scrubCheckBox;
    private JSlider scrubSlider;

    public AnimControlPanel(Cal3dModel character, String id, CalCoreAnimation anim) {
        this.character = character;
        this.id = id;
        this.initComponents();
    }

    private void initComponents() {
        this.idLabel = new JLabel();
        this.blendSlider = new JSlider();
        this.scrubSlider = new JSlider();
        this.scrubCheckBox = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.bindKeyButton = new JButton();
        this.actionButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.idLabel.setBackground(new Color(204, 204, 255));
        this.idLabel.setFont(new Font("MS Sans Serif", 3, 11));
        this.idLabel.setForeground(new Color(0, 0, 153));
        this.idLabel.setText("Anim Id");
        this.idLabel.setBorder(new BevelBorder(0));
        this.idLabel.setText(this.id);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.idLabel, gridBagConstraints);
        this.blendSlider.setValue(0);
        this.blendSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AnimControlPanel.this.blendSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.blendSlider, gridBagConstraints);
        this.scrubSlider.setValue(0);
        this.scrubSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AnimControlPanel.this.scrubSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.scrubSlider, gridBagConstraints);
        this.scrubCheckBox.setText("Freeze: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.scrubCheckBox, gridBagConstraints);
        this.jLabel1.setText("Weight: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jButton1.setText("Clear");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimControlPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.actionButton.setText("Do Action");
        this.actionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimControlPanel.this.actionButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.actionButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void bindKeyButtonActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.character.getInternalModel().getMixer().clearCycle(this.id, 0.0f);
    }

    private void scrubSliderStateChanged(ChangeEvent evt) {
        this.character.getInternalModel().getMixer().scrubToPosition(this.id, (float)this.scrubSlider.getValue() / 100.0f);
    }

    private void actionButtonActionPerformed(ActionEvent evt) {
        this.character.getInternalModel().getMixer().executeAction(this.id, 0.0f, 0.0f);
    }

    private void blendSliderStateChanged(ChangeEvent evt) {
        float blend = (float)this.blendSlider.getValue() / 100.0f;
        this.character.getInternalModel().getMixer().blendCycle(this.id, blend, 0.0f);
    }

    public void keyPressed() {
        this.character.getInternalModel().getMixer().executeAction(this.id, 0.0f, 0.0f);
    }
}

