/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.cal3d.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.impl.cal3d.Cal3dLoader;
import org.xith3d.loaders.models.impl.cal3d.Cal3dModel;
import org.xith3d.loaders.models.impl.cal3d.browser.AnimationBrowser;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointLight;

public class Cal3dBrowser {
    int width = 800;
    int height = 600;
    private SwingFrame frame = new SwingFrame();

    public Cal3dBrowser() {
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Cal3dBrowser();
    }

    class MyImplementor
    extends Xith3DEnvironment {
        Cal3dModel amodel;
        long startTime = 0L;
        long fps = 0L;
        SwingFrame frame;

        public Cal3dModel getModel() {
            return this.amodel;
        }

        public MyImplementor(int width, int height, SwingFrame fr, JPanel panel) {
            this.addCanvas(Canvas3DFactory.create(OpenGLLayer.JOGL_AWT, width, height, DisplayMode.WINDOWED, (Object)panel));
            this.frame = fr;
            this.simpleSetup();
        }

        public void simpleSetup() {
            BranchGroup scene = this.addPerspectiveBranch().getBranchGroup();
            AmbientLight aLight = new AmbientLight(new Colorf(0.3f, 0.3f, 0.3f));
            scene.addChild(aLight);
            PointLight light = new PointLight();
            light.setColor(1.0f, 1.0f, 1.0f);
            light.setLocation(50.0f, 50.0f, 50.0f);
            light.setAttenuation(5.0E-4f, 5.0E-4f, 5.0E-4f);
            scene.addChild(light);
            try {
                this.amodel = (Cal3dModel)new Cal3dLoader().loadModel("/home/bluesky/workspace/stratagem/data/models/units/fantassin/cal3d/Fantassin.cfg");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            scene.addChild(this.amodel);
            this.startTime = System.currentTimeMillis() + 5000L;
            this.amodel.getInternalModel().setLodLevel(1.0f);
            this.getView().lookAt(-5.0f, -5.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        public void update() {
            this.amodel.updateController(0.02f);
            this.render();
        }
    }

    class SwingFrame
    extends JFrame {
        private static final long serialVersionUID = 1L;
        JPanel contentPane;
        JPanel mainPanel = new JPanel();
        Component comp = null;
        JButton coolButton = new JButton();
        JButton uncoolButton = new JButton();
        JPanel spPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        JTree jTree1 = new JTree();
        JCheckBox scaleBox = new JCheckBox("Scale GL Image");
        JPanel colorPanel = new JPanel();
        JLabel colorLabel = new JLabel("BG Color:");
        MyImplementor impl;

        public SwingFrame() {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    SwingFrame.this.dispose();
                }
            });
            this.init();
            this.setSize(800, 600);
            this.doJob();
            new Thread(){
                {
                    this.setDaemon(true);
                }

                public void run() {
                    while (true) {
                        SwingFrame.this.impl.update();
                    }
                }
            }.start();
        }

        private void init() {
            this.contentPane = (JPanel)this.getContentPane();
            this.contentPane.setLayout(new BorderLayout());
            this.mainPanel.setLayout(new GridBagLayout());
            this.setTitle("CAL3D Animation Browser");
            JPanel panel = new JPanel();
            this.impl = new MyImplementor(Cal3dBrowser.this.width, Cal3dBrowser.this.height, this, panel);
            this.contentPane.add((Component)panel, "Center");
            this.impl.update();
        }

        public void doJob() {
            AnimationBrowser br = new AnimationBrowser(this.impl.getModel());
            this.getContentPane().add((Component)br, "West");
            this.repaint();
            this.validate();
        }

        protected void processWindowEvent(WindowEvent e) {
            super.processWindowEvent(e);
            if (e.getID() == 201) {
                System.exit(0);
            }
        }
    }
}

