/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.dae;

import java.util.HashMap;
import java.util.Map;
import org.jagatoo.loaders.models.collada.COLLADAAction;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.controllers.Controller;
import org.jagatoo.loaders.models.collada.datastructs.controllers.SkeletalController;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.AbstractInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.ControllerInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.GeometryInstance;
import org.jagatoo.loaders.models.collada.datastructs.visualscenes.Node;
import org.openmali.spatial.bodies.Frustum;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.models.impl.dae.DaeConverter;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.View;

public class DaeModel
extends Model {
    private final AssetFolder assetFolder;
    private final HashMap<AbstractInstance, Geometry> instanceMap = new HashMap();

    public final AssetFolder getAssetFolder() {
        return this.assetFolder;
    }

    public void interpolateAnimation(float animStartTime, float absAnimTime) {
    }

    private void updateGeometry() {
        for (Map.Entry<AbstractInstance, Geometry> entry : this.instanceMap.entrySet()) {
            if (entry.getKey() instanceof ControllerInstance) {
                ControllerInstance ci = (ControllerInstance)entry.getKey();
                DaeConverter.update(ci.getController().getDestinationGeometry(), entry.getValue());
                continue;
            }
            if (!(entry.getKey() instanceof GeometryInstance)) continue;
            GeometryInstance gi = (GeometryInstance)entry.getKey();
            DaeConverter.update(gi.getGeometry(), entry.getValue());
        }
    }

    public boolean update(View view, Frustum frustum, long nanoTime, long nanoStep) {
        if (this.getCurrentAnimation() == null) {
            return true;
        }
        this.assetFolder.getModel().animate(UpdatingThread.TimingMode.NANOSECONDS.getMilliSeconds(nanoTime));
        this.updateGeometry();
        return true;
    }

    public Model getSharedInstance() {
        return this.getSharedInstance();
    }

    public DaeModel(AssetFolder assetFolder, Node colladaNode) {
        this.assetFolder = assetFolder;
        this.addChild(DaeConverter.toXith3D(colladaNode, this.instanceMap));
        for (Controller c : assetFolder.getLibraryControllers().getControllers().values()) {
            if (!(c instanceof SkeletalController)) continue;
            COLLADAAction action = (COLLADAAction)assetFolder.getLibraryAnimations().getAnimations().values().iterator().next();
            assetFolder.getModel().initAnimation(action.getId(), true);
            ModelAnimation[] animations = new ModelAnimation[]{new ModelAnimation(action.getId(), action.rotKeyFrames.size(), 25.0f, null, action)};
            this.setAnimations(animations);
        }
    }
}

