/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.dae;

import java.awt.Font;
import java.util.HashMap;
import org.jagatoo.loaders.models.collada.datastructs.animation.Bone;
import org.jagatoo.loaders.models.collada.datastructs.animation.Skeleton;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.scenegraph.primitives.TextBillboard;

public class SkeletonXRayVisualizer
extends Group {
    private final Skeleton skeleton;
    private final HashMap<Bone, Line> mapLines = new HashMap();
    private final HashMap<Bone, Transform> mapSpheres = new HashMap();

    private void update(Bone parentBone, Bone bone) {
        if (!this.mapLines.containsKey(bone)) {
            Line line = new Line((Tuple3f)Point3f.ZERO, bone.numChildren() > 0 ? Colorf.GREEN : Colorf.WHITE);
            line.setAntialiasingEnabled(true);
            line.setWidth(4.0f);
            line.getGeometry().setOptimization(Geometry.Optimization.NONE);
            this.mapLines.put(bone, line);
            this.addChild(line);
        }
        if (!this.mapSpheres.containsKey(bone)) {
            Transform transform = new Transform();
            transform.add(new Sphere(0.05f, 10, 10, Colorf.RED));
            transform.add(TextBillboard.createFixedHeight(0.2f, bone.getName(), Colorf.WHITE, Font.decode("Arial-plain-20")));
            this.mapSpheres.put(bone, transform);
            this.addChild(transform);
        }
        Vector3f b = new Vector3f();
        b.set((TupleNf)(parentBone == null ? bone.getAbsoluteTranslation() : parentBone.getAbsoluteTranslation()));
        Vector3f e = new Vector3f();
        e.set((TupleNf)bone.getAbsoluteTranslation());
        this.mapLines.get(bone).setCoordinates((Tuple3f)b, (Tuple3f)e);
        this.mapSpheres.get(bone).setTranslation(b.getX(), b.getY(), b.getZ());
        for (int i = 0; i < bone.numChildren(); ++i) {
            this.update(bone, bone.getChild(i));
        }
    }

    public final void update() {
        this.update(null, this.skeleton.getRootBone());
    }

    public SkeletonXRayVisualizer(Skeleton skeleton) {
        this.skeleton = skeleton;
    }
}

