/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.util.meta;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.util.meta.ModelMetaData;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.utility.logging.X3DLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaLoader<D extends ModelMetaData>
extends ModelLoader {
    private static final SAXParserFactory SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private URL metaBaseURL;

    private void process(Model model, D meta) {
        Vector3f rotationAngle;
        model.setMetaData((ModelMetaData)meta);
        float scale = ((ModelMetaData)meta).getScaling();
        AxisAngle3f rotation = ((ModelMetaData)meta).getRotation();
        if (rotation != null) {
            rotationAngle = new Vector3f(rotation.getX(), rotation.getY(), rotation.getZ());
            if (rotationAngle.lengthSquared() == 0.0f) {
                ParsingException e = new ParsingException("Rotation Axis can not be length 0");
                X3DLog.print((Throwable)e);
                throw e;
            }
        } else {
            rotationAngle = null;
        }
        for (int i = 0; i < model.getShapesCount(); ++i) {
            Shape3D shape = model.getShape(i);
            StaticTransform.scale(shape, scale);
            if (rotation == null) continue;
            StaticTransform.rotate(shape, (Tuple3f)rotationAngle, rotation.getAngle());
        }
        List<TransformGroup> transformGroups = model.findAll(TransformGroup.class);
        if (transformGroups != null) {
            for (int i = 0; i < transformGroups.size(); ++i) {
                if (rotation == null) continue;
            }
        }
    }

    public void setMetaBaseURL(URL metaBaseURL) {
        this.metaBaseURL = metaBaseURL;
    }

    public URL getMetaBaseURL() {
        return this.metaBaseURL;
    }

    private URL createMetaURL(URL baseURL, D meta) throws MalformedURLException {
        URL retVal = null;
        if (((ModelMetaData)meta).isResourceRefrenceBase()) {
            retVal = new URL(this.getMetaBaseURL(), ((ModelMetaData)meta).getResourceName());
        } else if (((ModelMetaData)meta).isResourceRefrenceRelative()) {
            retVal = new URL(baseURL, ((ModelMetaData)meta).getResourceName());
        }
        return retVal;
    }

    private final D loadMeta(URL url) throws IOException {
        SAXParser saxParser;
        try {
            saxParser = SAX_PARSER_FACTORY.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        catch (SAXException e) {
            throw new Error(e);
        }
        try {
            saxParser.setProperty("http://xml.org/sax/features/validation", false);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        MetaParser handler = new MetaParser();
        try {
            saxParser.parse(url.openStream(), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new ParsingException((Throwable)e);
        }
        return (D)handler.getMetaData();
    }

    @Override
    public Model loadModel(URL url, String filenameBase, URL baseURL, String skin, float scale, int flags) throws IOException, IncorrectFormatException, ParsingException {
        D meta = this.loadMeta(url);
        Model model = ModelLoader.getInstance().loadModel(this.createMetaURL(baseURL, meta), skin);
        this.process(model, meta);
        return model;
    }

    private static class MetaParser
    extends DefaultHandler {
        private int level = -1;
        private String[] path = new String[16];
        private ModelMetaData meta = new ModelMetaData();

        private MetaParser() {
        }

        private final String getCurrentPathAsString() {
            String p = "";
            for (int i = 0; i < this.level; ++i) {
                p = p + '/' + this.path[i];
            }
            return p;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.path[++this.level] = qName;
            if (qName.equals("resource")) {
                String type = attributes.getValue("type");
                if (type.equals("base")) {
                    this.meta.setResourceRefrenceBase();
                } else {
                    this.meta.setResourceRefrenceRelative();
                }
            } else if (qName.equals("rotation")) {
                String type = attributes.getValue("type");
                if (type.equals("AXIS_ANGLE")) {
                    float x = Float.parseFloat(attributes.getValue("x"));
                    float y = Float.parseFloat(attributes.getValue("y"));
                    float z = Float.parseFloat(attributes.getValue("z"));
                    float angle = Float.parseFloat(attributes.getValue("angle"));
                    this.meta.setRotation(new AxisAngle3f(x, y, z, angle));
                }
            } else if (qName.equals("loadingFlag")) {
                String name = attributes.getValue("name");
                boolean value = Boolean.parseBoolean(attributes.getValue("value"));
                if (name.equals("LIGHT_NODES")) {
                    this.meta.getLoadingFlags().lightNodes = value;
                } else if (name.equals("FOG_NODES")) {
                    this.meta.getLoadingFlags().fogNodes = value;
                } else if (name.equals("BACKGROUND_NODES")) {
                    this.meta.getLoadingFlags().backgroundNodes = value;
                } else if (name.equals("BEHAVIOR_NODES")) {
                    this.meta.getLoadingFlags().behaviorNodes = value;
                } else if (name.equals("VIEW_GROUPS")) {
                    this.meta.getLoadingFlags().viewGroups = value;
                } else if (name.equals("SOUND_NODES")) {
                    this.meta.getLoadingFlags().soundNodes = value;
                } else if (name.equals("USE_DISPLAY_LISTS")) {
                    this.meta.getLoadingFlags().useDisplayLists = value;
                }
            }
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.path[this.level].equals("resource")) {
                this.meta.setResourceName(new String(data, start, length).trim());
            } else if (this.path[this.level].equals("scaling")) {
                this.meta.setScaling(Float.parseFloat(new String(data, start, length).trim()));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.path[this.level--] = null;
        }

        public void warning(SAXParseException e) throws SAXException {
            System.err.println("Warning at: " + this.getCurrentPathAsString());
            e.printStackTrace();
        }

        public void error(SAXParseException e) throws SAXException {
            System.err.println("Error at: " + this.getCurrentPathAsString());
            e.printStackTrace();
        }

        public void fatalError(SAXParseException e) throws SAXException {
            System.err.println("Warning at: " + this.getCurrentPathAsString());
            throw e;
        }

        public ModelMetaData getMetaData() {
            return this.meta;
        }
    }
}

