/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.util.specific;

import java.io.IOException;
import java.net.URL;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TransformGroup;

public class MD3Tools {
    public static Model loadMultipartModel(URL legs, String torsoMount, URL torso, String headMount, URL head, URL weapon, String skin, Material material, float scale) throws IOException, IncorrectFormatException, ParsingException {
        ModelLoader loader = ModelLoader.getInstance();
        Texture2D skinTex = null;
        if (skin != null) {
            skinTex = TextureLoader.getInstance().getTexture(skin);
        }
        Model mdlLegs = loader.loadModel(legs, "", scale);
        if (skinTex != null) {
            mdlLegs.getShape(0).getAppearance().setTexture(skinTex);
        }
        mdlLegs.getShape(0).getAppearance().setMaterial(material);
        if (torso != null) {
            TransformGroup mt;
            Model mdlTorso = loader.loadModel(torso, "", scale);
            if (skinTex != null) {
                mdlTorso.getShape(0).getAppearance().setTexture(skinTex);
            }
            mdlTorso.getShape(0).getAppearance().setMaterial(material);
            if (mdlTorso.hasAnimations()) {
                mdlLegs.getAnimations()[0].attachAnimation(mdlTorso.getAnimations()[0]);
            }
            if (torsoMount == null) {
                torsoMount = "tag_torso";
            }
            if ((mt = mdlLegs.getMountTransform(torsoMount)) != null) {
                mt.addChild(mdlTorso);
            }
            if (head != null) {
                TransformGroup mt2;
                Model mdlHead = loader.loadModel(head, "", scale);
                if (skinTex != null) {
                    mdlHead.getShape(0).getAppearance().setTexture(skinTex);
                }
                mdlHead.getShape(0).getAppearance().setMaterial(material);
                if (mdlHead.hasAnimations()) {
                    mdlLegs.getAnimations()[0].attachAnimation(mdlHead.getAnimations()[0]);
                }
                if (headMount == null) {
                    headMount = "tag_head";
                }
                if ((mt2 = mdlTorso.getMountTransform("tag_head")) != null) {
                    mt2.addChild(mdlHead);
                }
            }
        }
        return mdlLegs;
    }

    public static Model loadMultipartModel(URL legs, String torsoMount, URL torso, String headMount, URL head, URL weapon, String skin, float scale) throws IOException, IncorrectFormatException, ParsingException {
        return MD3Tools.loadMultipartModel(legs, torsoMount, torso, headMount, head, weapon, skin, null, scale);
    }
}

