/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.util.specific.bsp;

import java.util.BitSet;
import org.jagatoo.loaders.models.bsp.BSPClusterManager;
import org.jagatoo.loaders.models.bsp.lumps.BSPVisData;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.loaders.models.Model;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.collideable.TriMeshCollideable;
import org.xith3d.scenegraph.Shape3D;

public class CollisionEnabledClusterManager
extends BSPClusterManager {
    private final CollideableGroup sceneCollGroup;

    public final CollideableGroup getCollideableGroup() {
        return this.sceneCollGroup;
    }

    private static final CollideableGroup createCollideables(Model scene, CollisionEngine collEngine) {
        CollideableGroup sceneCollGroup = collEngine.newGroup("Simple");
        for (int i = 0; i < scene.getShapesCount(); ++i) {
            Shape3D shape = scene.getShape(i);
            TriMeshCollideable coll = collEngine.newTriMesh(shape);
            sceneCollGroup.addCollideable(coll);
        }
        return sceneCollGroup;
    }

    public boolean updateVisibility(Matrix4f cameraTransform) {
        boolean result = super.updateVisibility(cameraTransform);
        if (result) {
            for (int i = 0; i < this.sceneCollGroup.getChildrenCount(); ++i) {
                Collideable coll = this.sceneCollGroup.getChild(i);
                coll.setEnabled(this.shapeBitset.get(i));
            }
        }
        return result;
    }

    public CollisionEnabledClusterManager(BSPVisData bspVisData, int[][][] clusterLeafs, int[] leafToCluster, float[] planes, int[] nodes, Model scene, CollisionEngine collEngine, BitSet faceBitset) {
        super(bspVisData, clusterLeafs, leafToCluster, planes, nodes, faceBitset);
        this.sceneCollGroup = CollisionEnabledClusterManager.createCollideables(scene, collEngine);
    }

    public CollisionEnabledClusterManager(BSPClusterManager template, Model scene, CollisionEngine collEngine) {
        super(template);
        this.sceneCollGroup = CollisionEnabledClusterManager.createCollideables(scene, collEngine);
    }
}

