/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.shaders.impl.glsl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.xith3d.loaders.shaders.base.ShaderLoader;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLShader;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Shader;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLShaderLoader
extends ShaderLoader<GLSLShader> {
    private static final GLSLShaderLoader instance = new GLSLShaderLoader();

    public GLSLShader loadShader(Reader reader, Shader.ShaderType type, InlineVariableMapping ... inlineVariables) throws IOException {
        BufferedReader buffReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        GLSLShader shader = null;
        StringBuilder shaderSource = new StringBuilder();
        try {
            String line;
            while ((line = buffReader.readLine()) != null) {
                int offset = 0;
                if (inlineVariables != null) {
                    for (int i = 0; i < inlineVariables.length; ++i) {
                        InlineVariableMapping mapping = inlineVariables[i];
                        int pos = line.indexOf(mapping.getSearchString(), offset);
                        if (pos < 0) continue;
                        shaderSource.append(line, offset, pos);
                        shaderSource.append(mapping.getValueAsString());
                        offset = pos + mapping.getSearchString().length();
                    }
                }
                if (line.indexOf("${", offset) >= 0) {
                    throw new Error("Found unmapped inline variabled remaining in the shader source.");
                }
                if (offset > 0) {
                    shaderSource.append(line, offset, line.length());
                } else {
                    shaderSource.append(line);
                }
                shaderSource.append('\n');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (shaderSource.length() == 0) {
            X3DLog.exception("failed to load shader \"...\"");
            return null;
        }
        shader = type == Shader.ShaderType.FRAGMENT ? new GLSLFragmentShader(shaderSource.toString()) : new GLSLVertexShader(shaderSource.toString());
        if (shader == null) {
            X3DLog.exception("failed to load shader \"...\"");
            return null;
        }
        return shader;
    }

    @Override
    public GLSLShader loadShader(Reader reader, Shader.ShaderType type) throws IOException {
        return this.loadShader(reader, type, (InlineVariableMapping[])null);
    }

    public GLSLShader loadShader(InputStream in, Shader.ShaderType type, InlineVariableMapping ... inlineVariables) throws IOException {
        return this.loadShader(new InputStreamReader(in), type, inlineVariables);
    }

    @Override
    public GLSLShader loadShader(InputStream in, Shader.ShaderType type) throws IOException {
        return this.loadShader(new InputStreamReader(in), type, (InlineVariableMapping[])null);
    }

    public GLSLShader loadShader(URL url, Shader.ShaderType type, InlineVariableMapping ... inlineVariables) throws IOException {
        return this.loadShader(url.openStream(), type, inlineVariables);
    }

    @Override
    public GLSLShader loadShader(URL url, Shader.ShaderType type) throws IOException {
        return this.loadShader(url.openStream(), type, (InlineVariableMapping[])null);
    }

    @Override
    public GLSLShader loadShader(String name, Shader.ShaderType type) throws IOException {
        String cacheTag = (Object)((Object)type) + name;
        GLSLShader shader = (GLSLShader)this.getFromCache(cacheTag);
        if (shader != null) {
            return shader;
        }
        File shaderFile = new File(name);
        if (shaderFile.exists()) {
            shader = this.loadShader(new FileReader(name), type);
        } else if (this.getBaseURL() != null) {
            shader = this.loadShader(new URL(this.getBaseURL(), name).openStream(), type);
        } else if (this.getBasePath() != null) {
            shader = this.loadShader(new FileReader(new File(this.getBasePath(), name)), type);
        }
        if (shader == null) {
            X3DLog.error("failed to load shader \"", name, "\"");
            return null;
        }
        this.cacheShader(cacheTag, shader);
        return shader;
    }

    public GLSLVertexShader loadVertexShader(URL url, InlineVariableMapping ... inlineVariables) throws IOException {
        return (GLSLVertexShader)this.loadShader(url, Shader.ShaderType.VERTEX, inlineVariables);
    }

    public GLSLVertexShader loadVertexShader(URL url) throws IOException {
        return (GLSLVertexShader)this.loadShader(url, Shader.ShaderType.VERTEX, (InlineVariableMapping[])null);
    }

    public GLSLVertexShader loadVertexShader(String name) throws IOException {
        return (GLSLVertexShader)this.loadShader(name, Shader.ShaderType.VERTEX);
    }

    public GLSLFragmentShader loadFragmentShader(URL url, InlineVariableMapping ... inlineVariables) throws IOException {
        return (GLSLFragmentShader)this.loadShader(url, Shader.ShaderType.FRAGMENT, inlineVariables);
    }

    public GLSLFragmentShader loadFragmentShader(URL url) throws IOException {
        return (GLSLFragmentShader)this.loadShader(url, Shader.ShaderType.FRAGMENT, (InlineVariableMapping[])null);
    }

    public GLSLFragmentShader loadFragmentShader(String name) throws IOException {
        return (GLSLFragmentShader)this.loadShader(name, Shader.ShaderType.FRAGMENT);
    }

    public GLSLShader loadShaderFromString(String source, Shader.ShaderType typ, InlineVariableMapping ... inlineVariables) {
        if (inlineVariables == null || inlineVariables.length == 0 || source.indexOf("${") < 0) {
            if (typ == Shader.ShaderType.FRAGMENT) {
                return new GLSLFragmentShader(source);
            }
            return new GLSLVertexShader(source);
        }
        try {
            return this.loadShader(new StringReader(source), typ, inlineVariables);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public GLSLShader loadShaderFromString(String source, Shader.ShaderType typ) {
        return this.loadShaderFromString(source, typ, null);
    }

    public GLSLVertexShader loadVertexShaderFromString(String source, InlineVariableMapping ... inlineVariables) {
        return (GLSLVertexShader)this.loadShaderFromString(source, Shader.ShaderType.VERTEX, inlineVariables);
    }

    public GLSLVertexShader loadVertexShaderFromString(String source) {
        return (GLSLVertexShader)this.loadShaderFromString(source, Shader.ShaderType.VERTEX, null);
    }

    public GLSLFragmentShader loadFragmentShaderFromString(String source, InlineVariableMapping ... inlineVariables) {
        return (GLSLFragmentShader)this.loadShaderFromString(source, Shader.ShaderType.FRAGMENT, inlineVariables);
    }

    public GLSLFragmentShader loadFragmentShaderFromString(String source) {
        return (GLSLFragmentShader)this.loadShaderFromString(source, Shader.ShaderType.FRAGMENT, null);
    }

    public GLSLShaderLoader(URL baseURL) {
        super(baseURL);
    }

    public GLSLShaderLoader(String basePath) {
        super(basePath);
    }

    public GLSLShaderLoader() {
    }

    public static GLSLShaderLoader getInstance() {
        return instance;
    }

    public static final class InlineVariableMapping {
        private final String variableName;
        private final String searchString;
        private final Object value;
        private final String strValue;

        public final String getVariableName() {
            return this.variableName;
        }

        public final String getSearchString() {
            return this.searchString;
        }

        public final Object getValue() {
            return this.value;
        }

        public final String getValueAsString() {
            return this.strValue;
        }

        public InlineVariableMapping(String variableName, Object value) {
            if (variableName == null || value == null) {
                throw new IllegalArgumentException("Neither variableName nor value must be null.");
            }
            this.variableName = variableName;
            this.searchString = "${" + variableName + "}";
            this.value = value;
            this.strValue = value.toString();
        }
    }
}

