/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.sound;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xith3d.loaders.sound.SoundLoader;
import org.xith3d.loaders.sound.impl.midi.MidiLoader;
import org.xith3d.loaders.sound.impl.ogg.OggLoader;
import org.xith3d.loaders.sound.impl.wav.WaveLoader;
import org.xith3d.sound.SoundContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionSoundLoader
extends SoundLoader {
    private static ExtensionSoundLoader singletonInstance = null;
    private Map<String, SoundLoader> extensionMap;

    public static ExtensionSoundLoader getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ExtensionSoundLoader();
        }
        return singletonInstance;
    }

    public void setExtensionMap(Map<String, SoundLoader> extensionMap) {
        this.extensionMap = extensionMap;
    }

    public Map<String, SoundLoader> getExtensionMap() {
        return this.extensionMap;
    }

    public void mapExtension(String extension, SoundLoader loader) {
        this.extensionMap.put(extension.toLowerCase(), loader);
    }

    public SoundLoader getMappedSoundLoader(String extension) {
        return this.extensionMap.get(extension.toLowerCase());
    }

    private static String getExtension(String resource) {
        if (resource == null || !resource.equals(".") && resource.length() < 2) {
            throw new IllegalArgumentException("Illegal Sound resource \"" + resource + "\"");
        }
        int lastDotPos = resource.lastIndexOf(46);
        if (lastDotPos >= 0) {
            return resource.substring(lastDotPos + 1);
        }
        return resource;
    }

    @Override
    public SoundContainer loadSound(InputStream in) throws IOException {
        throw new UnsupportedOperationException("You cannot load directly from an InputStream with the ExtensionSoundLoader.");
    }

    @Override
    public SoundContainer loadSound(URL url) throws IOException {
        SoundLoader loader = this.getMappedSoundLoader(ExtensionSoundLoader.getExtension(url.toString()));
        if (loader == null) {
            throw new UnsupportedOperationException("There's no (registered) SoundLoader implementation for \"" + ExtensionSoundLoader.getExtension(url.toString()) + "\"");
        }
        return loader.loadSound(url);
    }

    @Override
    public SoundContainer loadSound(String filename) throws IOException {
        SoundLoader loader = this.getMappedSoundLoader(ExtensionSoundLoader.getExtension(filename));
        if (loader == null) {
            throw new UnsupportedOperationException("There's no (registered) SoundLoader implementation for \"" + ExtensionSoundLoader.getExtension(filename) + "\"");
        }
        return loader.loadSound(filename);
    }

    public ExtensionSoundLoader(Map<String, SoundLoader> extensionMap) {
        this.setExtensionMap(extensionMap);
    }

    private static Map<String, SoundLoader> createDefaultExtMap() {
        HashMap<String, SoundLoader> extensionMap = new HashMap<String, SoundLoader>();
        extensionMap.put("wav", WaveLoader.getInstance());
        extensionMap.put("ogg", OggLoader.getInstance());
        extensionMap.put("mid", MidiLoader.getInstance());
        return extensionMap;
    }

    public ExtensionSoundLoader() {
        this(ExtensionSoundLoader.createDefaultExtMap());
    }
}

