/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.sound.impl.midi;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xith3d.loaders.sound.SoundLoader;
import org.xith3d.loaders.sound.impl.midi.MidiSoundContainer;

public class MidiLoader
extends SoundLoader {
    public static final String DEFAULT_EXTENSION = "mid";
    private static MidiLoader singletonInstance = null;

    public static MidiLoader getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new MidiLoader();
        }
        return singletonInstance;
    }

    public MidiSoundContainer loadSound(InputStream in) throws IOException {
        try {
            return MidiSoundContainer.load(in);
        }
        catch (Exception e) {
            IOException e2 = new IOException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    public MidiSoundContainer loadSound(URL url) throws IOException {
        return this.loadSound(url.openStream());
    }

    public MidiSoundContainer loadSound(String filename) throws IOException {
        return this.loadSound(new BufferedInputStream(new FileInputStream(filename)));
    }
}

