/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.sound.impl.midi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import org.xith3d.sound.SingletonSoundContainer;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundDriver;

public class MidiSoundContainer
implements SingletonSoundContainer {
    private Sequencer sequencer;

    public void setEnabled(boolean enabled) {
        if (enabled && !this.sequencer.isRunning()) {
            this.sequencer.start();
        } else if (!enabled && this.sequencer.isRunning()) {
            this.sequencer.stop();
        }
    }

    public void setPaused(boolean paused) {
        this.setEnabled(!paused);
    }

    public long getDuration() {
        return this.sequencer.getMicrosecondLength();
    }

    protected void finalize() {
        this.sequencer.stop();
        this.sequencer.close();
    }

    public boolean isStreaming() {
        return true;
    }

    public SoundBuffer getData(SoundDriver driver) {
        return null;
    }

    public void returnData(SoundDriver driver, SoundBuffer buffer) {
    }

    public void rewind(SoundDriver driver) {
    }

    private MidiSoundContainer(Sequencer sequencer) {
        this.sequencer = sequencer;
        sequencer.start();
    }

    static MidiSoundContainer load(InputStream inputStream) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        Sequencer sequencer = MidiSystem.getSequencer();
        sequencer.setSequence(MidiSystem.getSequence(inputStream));
        sequencer.open();
        return new MidiSoundContainer(sequencer);
    }
}

