/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.sound.impl.wav;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.xith3d.loaders.sound.SoundLoader;
import org.xith3d.loaders.sound.impl.wav.WaveData;
import org.xith3d.loaders.sound.impl.wav.WaveSoundContainer;
import org.xith3d.sound.BufferFormat;

public class WaveLoader
extends SoundLoader {
    public static final String DEFAULT_EXTENSION = "wav";
    private static WaveLoader singletonInstance = null;

    public static WaveLoader getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new WaveLoader();
        }
        return singletonInstance;
    }

    private static WaveData loadFromAudioInputStream(AudioInputStream aIn) throws UnsupportedAudioFileException, IOException {
        WaveData result = null;
        ReadableByteChannel aChannel = Channels.newChannel(aIn);
        AudioFormat fmt = aIn.getFormat();
        int numChannels = fmt.getChannels();
        int bits = fmt.getSampleSizeInBits();
        BufferFormat format = null;
        try {
            format = BufferFormat.getFromValues(bits, numChannels);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            format = BufferFormat.MONO8;
        }
        int freq = Math.round(fmt.getSampleRate());
        int size = aIn.available();
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        aChannel.read(buffer);
        result = new WaveData(buffer, format, size, freq, false);
        aIn.close();
        return result;
    }

    public WaveSoundContainer loadSound(InputStream in) throws IOException {
        try {
            WaveData wd = WaveLoader.loadFromAudioInputStream(AudioSystem.getAudioInputStream(in));
            WaveSoundContainer container = new WaveSoundContainer(wd);
            return container;
        }
        catch (UnsupportedAudioFileException e) {
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
    }

    public WaveSoundContainer loadSound(URL url) throws IOException {
        try {
            WaveData wd = WaveLoader.loadFromAudioInputStream(AudioSystem.getAudioInputStream(url));
            WaveSoundContainer container = new WaveSoundContainer(wd);
            return container;
        }
        catch (UnsupportedAudioFileException e) {
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
    }

    public WaveSoundContainer loadSound(String filename) throws IOException {
        try {
            WaveData wd = WaveLoader.loadFromAudioInputStream(AudioSystem.getAudioInputStream(new File(filename)));
            WaveSoundContainer container = new WaveSoundContainer(wd);
            return container;
        }
        catch (UnsupportedAudioFileException e) {
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
    }
}

