/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.texture;

import java.nio.ByteBuffer;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.opengl.enums.TextureImageInternalFormat;
import org.jagatoo.opengl.enums.TextureType;
import org.xith3d.scenegraph.Texture3D;
import org.xith3d.scenegraph.TextureImage3D;

public class Xith3DTextureFactory3D
extends TextureFactory {
    private final int depth;
    private TextureImage3D textureImage = null;
    private int imageCount = 0;

    public void skipOneImage() {
        ++this.imageCount;
        if (this.textureImage != null) {
            ByteBuffer bb = this.textureImage.getDataBuffer();
            bb.limit(bb.capacity());
        }
    }

    public TextureImage3D createTextureImageImpl(int width, int height, int orgWidth, int orgHeight, int pixelSize, int dataSize, TextureImageInternalFormat internalFormat, TextureImageFormat format) {
        if (this.textureImage == null) {
            this.textureImage = new TextureImage3D(format, width, height, this.depth);
        } else if (width != this.textureImage.getWidth() || width != this.textureImage.getWidth()) {
            throw new Error("All images must have the same size.");
        }
        int imageSize = this.textureImage.initImageData();
        ByteBuffer bb = this.textureImage.getDataBuffer();
        bb.position(imageSize * this.imageCount);
        bb.limit(bb.capacity());
        ++this.imageCount;
        return this.textureImage;
    }

    protected Texture3D createTextureImpl(TextureType type, TextureFormat format) {
        return new Texture3D(format);
    }

    public Xith3DTextureFactory3D(int depth) {
        this.depth = depth;
    }
}

