/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop;

import java.util.Vector;
import org.jagatoo.util.timing.JavaTimer;
import org.jagatoo.util.timing.TimerInterface;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.ConsciousFPSListener;
import org.xith3d.loop.FPSListener;
import org.xith3d.loop.GameTimeHost;
import org.xith3d.loop.RenderLoopController;
import org.xith3d.loop.RenderLoopListener;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.Updater;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.impl.OperationSchedulerImpl;
import org.xith3d.scenegraph.utils.LODWorkerThread;

public class RenderLoop
extends UpdatingThread
implements GameTimeHost,
Updater,
RenderLoopController {
    public static final int PAUSE_RENDERING = 2;
    private RunMode runMode = null;
    private boolean nextFrameAllowed = false;
    private float maxFPS;
    private float fps = 0.0f;
    private long fpsCalcInterval;
    private final Vector<FPSListener> fpsListeners;
    private final Vector<RenderLoopListener> rlListeners;
    private OperationScheduler opScheder;
    private Updater updater;
    private Xith3DEnvironment x3dEnv = null;
    private StopOperation stopOperation = null;
    private Thread thread = null;
    private long framesCountStartTime = 0L;
    private long framesCountTimeDelta;
    private int frames;

    public RunMode getRunMode() {
        return this.runMode;
    }

    public void setStopOperation(StopOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("StopOperation must not be null");
        }
        this.stopOperation = operation;
    }

    private StopOperation getStopOperation(RunMode runMode) {
        if (this.stopOperation == null) {
            if (runMode == null) {
                return null;
            }
            if (runMode == RunMode.RUN_IN_SEPARATE_THREAD) {
                return StopOperation.DESTROY_AND_EXIT;
            }
            if (runMode == RunMode.RUN_IN_SEPARATE_THREAD_AND_WAIT) {
                return StopOperation.DESTROY;
            }
            return StopOperation.DESTROY_AND_EXIT;
        }
        return this.stopOperation;
    }

    public StopOperation getStopOperation() {
        return this.getStopOperation(this.getRunMode());
    }

    public void setOperationScheduler(OperationScheduler opScheder) {
        if (this.opScheder == opScheder) {
            return;
        }
        this.opScheder = opScheder;
    }

    public final OperationScheduler getOperationScheduler() {
        return this.opScheder;
    }

    public Animator getAnimator() {
        return this.opScheder;
    }

    public void addFPSListener(FPSListener l) {
        this.fpsListeners.add(l);
        if (l instanceof ConsciousFPSListener) {
            ((ConsciousFPSListener)l).setRenderLoop(this);
        }
    }

    public void removeFPSListener(FPSListener l) {
        this.fpsListeners.remove(l);
        if (l instanceof ConsciousFPSListener) {
            ((ConsciousFPSListener)l).setRenderLoop(null);
        }
    }

    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public final Updater getUpdater() {
        return this.updater;
    }

    public final void addUpdatable(Updatable updatable) {
        if (this.updater == null) {
            throw new NullPointerException("No Updater present!");
        }
        this.updater.addUpdatable(updatable);
    }

    public final void removeUpdatable(Updatable updatable) {
        if (this.updater == null) {
            throw new NullPointerException("No Updater present!");
        }
        this.updater.removeUpdatable(updatable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderLoopListener(RenderLoopListener l) {
        Vector<RenderLoopListener> vector = this.rlListeners;
        synchronized (vector) {
            this.rlListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderLoopListener(RenderLoopListener l) {
        Vector<RenderLoopListener> vector = this.rlListeners;
        synchronized (vector) {
            this.rlListeners.remove(l);
        }
    }

    public void setXith3DEnvironment(Xith3DEnvironment env) {
        this.x3dEnv = env;
    }

    public final Xith3DEnvironment getXith3DEnvironment() {
        return this.x3dEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRenderLoopStarted() {
        Vector<RenderLoopListener> vector = this.rlListeners;
        synchronized (vector) {
            for (int i = 0; i < this.rlListeners.size(); ++i) {
                this.rlListeners.get(i).onRenderLoopStarted(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRenderLoopStopped(long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
        Vector<RenderLoopListener> vector = this.rlListeners;
        synchronized (vector) {
            for (int i = 0; i < this.rlListeners.size(); ++i) {
                this.rlListeners.get(i).onRenderLoopStopped(this, this.getGameTime(), timingMode, averageFPS);
            }
        }
    }

    protected void destroy() {
        LODWorkerThread.getInstance().shutDown();
        if (this.x3dEnv != null) {
            this.x3dEnv.destroy();
        }
    }

    protected void exit() {
        System.gc();
        System.exit(0);
    }

    protected void destroyAndExit() {
        this.destroy();
        this.exit();
    }

    public void end() {
        if (this.getThread() == null) {
            if (this.getStopOperation() == null) {
                this.destroyAndExit();
            } else {
                switch (this.getStopOperation()) {
                    case DO_NOTHING: {
                        break;
                    }
                    case DESTROY: {
                        this.destroy();
                        break;
                    }
                    case EXIT: {
                        this.exit();
                        break;
                    }
                    case DESTROY_AND_EXIT: {
                        this.destroyAndExit();
                    }
                }
            }
        } else {
            super.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRenderLoopPaused(long gameTime, UpdatingThread.TimingMode timingMode, int pauseMode) {
        Vector<RenderLoopListener> vector = this.rlListeners;
        synchronized (vector) {
            for (int i = 0; i < this.rlListeners.size(); ++i) {
                this.rlListeners.get(i).onRenderLoopPaused(this, this.getGameTime(), timingMode, pauseMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRenderLoopResumed(long gameTime, UpdatingThread.TimingMode timingMode, int pauseMode) {
        Vector<RenderLoopListener> vector = this.rlListeners;
        synchronized (vector) {
            for (int i = 0; i < this.rlListeners.size(); ++i) {
                this.rlListeners.get(i).onRenderLoopResumed(this, this.getGameTime(), timingMode, pauseMode);
            }
        }
    }

    public void setMaxFPS(float maxFPS) {
        this.maxFPS = maxFPS;
        this.setMinIterationTime((long)(1.0E9f / maxFPS));
    }

    public float getMaxFPS() {
        return this.maxFPS;
    }

    public float getFPS() {
        return this.fps;
    }

    public float getTotalAverageFPS() {
        if (this.getGameNanoTime() == 0L) {
            return -1.0f;
        }
        return (float)this.getIterationsCount() / ((float)this.getGameNanoTime() / 1.0E9f);
    }

    public void setFPSCalcInterval(long micros) {
        this.fpsCalcInterval = micros;
    }

    public long getFPSCalcInterval() {
        return this.fpsCalcInterval;
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        OperationScheduler opScheder;
        if (this.x3dEnv != null) {
            this.x3dEnv.updatePhysicsEngine(gameTime, frameTime, timingMode);
            this.x3dEnv.updateInputSystem(gameTime, timingMode);
        }
        if ((opScheder = this.getOperationScheduler()) != null) {
            opScheder.update(gameTime, frameTime, timingMode);
        }
        if (this.updater != null && this.updater != opScheder) {
            this.updater.update(gameTime, frameTime, timingMode);
        }
    }

    protected void renderNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.x3dEnv != null) {
            this.x3dEnv.render(this.getGameNanoTime(), this.getLastNanoFrameTime());
        } else {
            System.err.println("No Xith3DEnvironment registered!");
        }
    }

    protected void loopIteration(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.prepareNextFrame(gameTime, frameTime, timingMode);
        if ((this.getPauseMode() & 2) == 0) {
            this.renderNextFrame(gameTime, frameTime, timingMode);
        }
    }

    protected void onFPSCountIntervalHit(float fps) {
        if (!this.fpsListeners.isEmpty()) {
            for (int i = 0; i < this.fpsListeners.size(); ++i) {
                this.fpsListeners.get(i).onFPSCountIntervalHit(this.getFPS());
            }
        }
    }

    private void calcFPS(long gameTime, UpdatingThread.TimingMode timingMode) {
        ++this.frames;
        this.framesCountTimeDelta = timingMode.getMicroSeconds(gameTime - this.framesCountStartTime);
        if (this.framesCountTimeDelta >= this.fpsCalcInterval) {
            this.fps = (float)this.frames / ((float)this.framesCountTimeDelta / 1000000.0f);
            this.framesCountStartTime = gameTime;
            this.frames = 0;
            this.onFPSCountIntervalHit(this.fps);
        }
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.loopIteration(gameTime, frameTime, timingMode);
    }

    protected long nextIteration(boolean force) {
        this.calcFPS(this.getGameTime(), this.getTimingMode());
        return super.nextIteration(force);
    }

    public long nextFrame() {
        if (this.runMode == null) {
            return this.nextIteration(true);
        }
        if (this.runMode == RunMode.RUN_IN_SEPARATE_THREAD_AND_WAIT) {
            this.nextFrameAllowed = true;
            return -1L;
        }
        throw new IllegalStateException("The RenderLoop is not in interactive mode.");
    }

    protected void loop() {
        if (this.runMode == RunMode.RUN_IN_SEPARATE_THREAD_AND_WAIT) {
            while (!this.isStopping()) {
                if (this.nextFrameAllowed) {
                    this.nextFrameAllowed = false;
                    this.nextIteration(false);
                    continue;
                }
                try {
                    Thread.sleep(this.getMinIterationTime() / 1000000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            while (!this.isStopping()) {
                this.nextIteration(false);
            }
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public void run() {
        this.onRenderLoopStarted();
        this.setPauseMode(0);
        super.run();
        RunMode tmpRunMode = this.runMode;
        this.runMode = null;
        this.onRenderLoopStopped(this.getGameTime(), this.getTimingMode(), this.getTotalAverageFPS());
        switch (this.getStopOperation(tmpRunMode)) {
            case DO_NOTHING: {
                break;
            }
            case DESTROY: {
                this.destroy();
                break;
            }
            case EXIT: {
                this.exit();
                break;
            }
            case DESTROY_AND_EXIT: {
                this.destroyAndExit();
            }
        }
    }

    public void begin(RunMode runMode, UpdatingThread.TimingMode timingMode) {
        if (!this.isRunning()) {
            if (this.x3dEnv != null) {
                this.x3dEnv.checkRenderPreferences();
            }
            this.setTimingMode(timingMode);
            this.runMode = runMode;
            this.nextFrameAllowed = false;
            System.gc();
            if (runMode == RunMode.RUN_IN_SEPARATE_THREAD || runMode == RunMode.RUN_IN_SEPARATE_THREAD_AND_WAIT) {
                this.thread = new Thread(this);
                this.thread.setName("Xith3D render thread");
                this.thread.start();
            } else {
                this.thread = Thread.currentThread();
                this.run();
            }
        }
    }

    public final void begin(RunMode runMode) {
        this.begin(runMode, UpdatingThread.TimingMode.MICROSECONDS);
    }

    public final void begin(UpdatingThread.TimingMode timingMode) {
        this.begin(RunMode.RUN_IN_SAME_THREAD, timingMode);
    }

    public final void begin() {
        this.begin(RunMode.RUN_IN_SAME_THREAD, UpdatingThread.TimingMode.MICROSECONDS);
    }

    public void pauseRendering() {
        this.setPauseMode(this.getPauseMode() + 2);
        this.onRenderLoopPaused(this.getGameTime(), this.getTimingMode(), this.getPauseMode());
    }

    public void resumeRendering() {
        this.setPauseMode(this.getPauseMode() - 2);
        this.onRenderLoopResumed(this.getGameTime(), this.getTimingMode(), this.getPauseMode());
    }

    public RenderLoop(Xith3DEnvironment x3dEnv, float maxFPS) {
        this.setTimer((TimerInterface)new JavaTimer());
        this.fpsListeners = new Vector();
        this.rlListeners = new Vector();
        this.setXith3DEnvironment(x3dEnv);
        this.setFPSCalcInterval(500000L);
        this.setMaxFPS(maxFPS);
        OperationSchedulerImpl opScheder = new OperationSchedulerImpl(this);
        this.setOperationScheduler(opScheder);
        this.setUpdater(opScheder);
    }

    public RenderLoop(float maxFPS) {
        this(null, maxFPS);
    }

    public RenderLoop(Xith3DEnvironment x3dEnv) {
        this(x3dEnv, Float.MAX_VALUE);
    }

    public RenderLoop() {
        this(Float.MAX_VALUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StopOperation {
        DO_NOTHING,
        EXIT,
        DESTROY,
        DESTROY_AND_EXIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunMode {
        RUN_IN_SAME_THREAD,
        RUN_IN_SEPARATE_THREAD,
        RUN_IN_SEPARATE_THREAD_AND_WAIT;

    }
}

