/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop.opscheduler.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xith3d.loop.GameTimeHost;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animatable;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.ScheduledOperation;

public class OperationSchedulerImpl
extends UpdatingThread
implements OperationScheduler {
    private List<ScheduledOperation> scheduledOps = Collections.synchronizedList(new ArrayList());
    private ConcurrentLinkedQueue<ScheduledOperation> oneTimeOps = new ConcurrentLinkedQueue();
    private List<Interval> intervals = Collections.synchronizedList(new ArrayList());
    private Vector<IntervalListener> intervalListeners = new Vector();
    private final Vector<Updatable> updatableList = new Vector();

    public final int getNumberOfSchedOps() {
        return this.scheduledOps.size() + this.oneTimeOps.size();
    }

    public final int getNumberOfIntevals() {
        return this.intervals.size();
    }

    public void scheduleOperation(ScheduledOperation schedOp) {
        if (schedOp.isPersistent()) {
            this.scheduledOps.add(schedOp);
        } else {
            this.oneTimeOps.add(schedOp);
        }
    }

    public void unscheduleOperation(ScheduledOperation schedOp) {
        this.scheduledOps.remove(schedOp);
    }

    public void addInterval(Interval interval) {
        interval.revive();
        this.intervals.add(interval);
    }

    public void removeAllIntervals() {
        this.intervals.clear();
    }

    public void addIntervalListener(IntervalListener il) {
        this.intervalListeners.add(il);
    }

    public IntervalListener removeIntervalListener(IntervalListener il) {
        if (this.intervalListeners.remove(il)) {
            return il;
        }
        return null;
    }

    public void addAnimatableObject(Animatable animObj, long gameTime, UpdatingThread.TimingMode timingMode) {
        this.scheduleOperation(animObj);
        if (gameTime >= 0L) {
            animObj.startAnimation(gameTime, timingMode);
        }
    }

    public void addAnimatableObject(Animatable animObj, boolean startAnimation) {
        if (startAnimation) {
            this.addAnimatableObject(animObj, this.getGameTime(), this.getTimingMode());
        } else {
            this.addAnimatableObject(animObj, -1L, this.getTimingMode());
        }
    }

    public void addAnimatableObject(Animatable anumObj) {
        this.addAnimatableObject(anumObj, true);
    }

    public void removeAnimatableObject(Animatable animObj) {
        this.unscheduleOperation(animObj);
    }

    protected void callIntervalListeners(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (!this.intervalListeners.isEmpty()) {
            for (int i = 0; i < this.intervalListeners.size(); ++i) {
                this.intervalListeners.get(i).onIntervalHit(interval, gameTime, frameTime, timingMode);
            }
        }
    }

    public void addUpdatable(Updatable updatable) {
        this.updatableList.add(updatable);
    }

    public void removeUpdatable(Updatable updatable) {
        this.updatableList.remove(updatable);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        int i;
        if (!this.intervals.isEmpty()) {
            i = 0;
            while (i < this.intervals.size()) {
                Interval interval = this.intervals.get(i);
                if (interval.isAlive() && interval.check(gameTime, frameTime, timingMode)) {
                    this.callIntervalListeners(interval, gameTime, frameTime, timingMode);
                }
                if (interval.isAlive()) {
                    ++i;
                    continue;
                }
                this.intervals.remove(i);
            }
        }
        if (!this.scheduledOps.isEmpty()) {
            i = 0;
            while (i < this.scheduledOps.size()) {
                ScheduledOperation schedOp = this.scheduledOps.get(i);
                if (schedOp.isAlive()) {
                    schedOp.update(gameTime, frameTime, timingMode);
                    ++i;
                    continue;
                }
                this.scheduledOps.remove(i);
            }
        }
        if (!this.oneTimeOps.isEmpty()) {
            ScheduledOperation schedOp;
            while ((schedOp = this.oneTimeOps.poll()) != null) {
                schedOp.update(gameTime, frameTime, timingMode);
            }
        }
        if (!this.updatableList.isEmpty()) {
            for (int i2 = 0; i2 < this.updatableList.size(); ++i2) {
                this.updatableList.get(i2).update(gameTime, frameTime, timingMode);
            }
        }
    }

    public void update(long gameTime) {
        this.update(gameTime, -1L, UpdatingThread.TimingMode.MILLISECONDS);
    }

    public void update() {
        this.update(-1L, -1L, UpdatingThread.TimingMode.MILLISECONDS);
    }

    public OperationSchedulerImpl(long minItTime, GameTimeHost gameTimeHost) {
        super(minItTime, gameTimeHost);
    }

    public OperationSchedulerImpl(long minItTime) {
        this(minItTime, null);
    }

    public OperationSchedulerImpl(GameTimeHost gameTimeHost) {
        this(0L, gameTimeHost);
    }

    public OperationSchedulerImpl() {
        this(0L, null);
    }
}

