/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop.opscheduler.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xith3d.loop.opscheduler.ScheduledScreenshot;
import org.xith3d.picking.ScheduledPicker;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.utility.general.CircularArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedOpsPool {
    private static CircularArray<ScheduledScreenshot> schededShots = new CircularArray(16);
    private static CircularArray<ScheduledPicker> schededPickers = new CircularArray(128);
    private static CircularArray<List<GroupNode>> groupLists = new CircularArray(128);

    public static ScheduledScreenshot allocateSchededScreenshot(Canvas3D canvas, File file, boolean alpha) {
        if (schededShots.isEmpty()) {
            return new ScheduledScreenshot(canvas, file, alpha);
        }
        return schededShots.pop();
    }

    public static void deallocateSchededScreenshot(ScheduledScreenshot schededShot) {
        schededShots.push(schededShot);
    }

    public static ScheduledPicker allocateScheduledPicker() {
        if (schededPickers.isEmpty()) {
            return new ScheduledPicker();
        }
        return schededPickers.pop();
    }

    public static void deallocateScheduledPicker(ScheduledPicker schededPicker) {
        schededPickers.push(schededPicker);
    }

    public static List<GroupNode> allocateGroupList() {
        if (groupLists.isEmpty()) {
            return new ArrayList<GroupNode>();
        }
        List<GroupNode> groupList = groupLists.pop();
        groupList.clear();
        return groupList;
    }

    public static void deallocateGroupList(List<GroupNode> groupList) {
        groupLists.push(groupList);
    }
}

